/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.ResourceListItemImpl;
import com.adobe.cq.wcm.core.components.models.Container;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerImpl
extends AbstractComponentImpl
implements Container {
    @Self
    protected SlingHttpServletRequest request;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    protected Style currentStyle;
    @OSGiService
    protected SlingModelFilter slingModelFilter;
    @OSGiService
    protected ModelFactory modelFactory;
    protected List<ListItem> items;
    protected List<Resource> childComponents;
    protected List<Resource> filteredChildComponents;
    protected Map<String, ? extends ComponentExporter> itemModels;
    private String[] exportedItemsOrder;
    private boolean backgroundColorEnabled;
    private boolean backgroundImageEnabled;
    private String backgroundImageReference;
    private String backgroundColor;
    private StringBuilder styleBuilder;

    @NotNull
    private List<Resource> readChildren() {
        ComponentManager componentManager;
        LinkedList<Resource> children = new LinkedList<Resource>();
        if (this.resource != null && (componentManager = (ComponentManager)this.request.getResourceResolver().adaptTo(ComponentManager.class)) != null) {
            this.resource.getChildren().forEach(res -> {
                Component component = componentManager.getComponentOfResource(res);
                if (component != null) {
                    children.add((Resource)res);
                }
            });
        }
        return children;
    }

    @NotNull
    protected List<Resource> getChildren() {
        if (this.childComponents == null) {
            this.childComponents = this.readChildren();
        }
        return this.childComponents;
    }

    @NotNull
    protected List<Resource> getFilteredChildren() {
        if (this.filteredChildComponents == null) {
            this.filteredChildComponents = new LinkedList<Resource>();
            this.slingModelFilter.filterChildResources(this.getChildren()).forEach(this.filteredChildComponents::add);
        }
        return this.filteredChildComponents;
    }

    @NotNull
    protected List<ListItem> readItems() {
        LinkedList<ListItem> items = new LinkedList<ListItem>();
        this.getChildren().forEach(res -> items.add(new ResourceListItemImpl(this.request, (Resource)res)));
        return items;
    }

    private void populateStyleProperties() {
        this.backgroundColorEnabled = (Boolean)this.currentStyle.get("backgroundColorEnabled", (Object)false);
        this.backgroundImageEnabled = (Boolean)this.currentStyle.get("backgroundImageEnabled", (Object)false);
        if (this.resource != null) {
            ValueMap properties = this.resource.getValueMap();
            this.backgroundColor = (String)properties.get("backgroundColor", String.class);
            this.backgroundImageReference = (String)properties.get("backgroundImageReference", String.class);
        }
    }

    private void setBackgroundStyleString() {
        this.styleBuilder = new StringBuilder();
        if (this.backgroundImageEnabled && !StringUtils.isEmpty((CharSequence)this.backgroundImageReference)) {
            this.styleBuilder.append("background-image:url(" + this.backgroundImageReference + ");background-size:cover;background-repeat:no-repeat;");
        }
        if (this.backgroundColorEnabled && !StringUtils.isEmpty((CharSequence)this.backgroundColor)) {
            this.styleBuilder.append("background-color:" + this.backgroundColor + ";");
        }
    }

    @Override
    @JsonIgnore
    public List<ListItem> getItems() {
        if (this.items == null) {
            this.items = this.readItems();
        }
        return this.items;
    }

    @Override
    @Nullable
    public String getBackgroundStyle() {
        String style;
        if (this.styleBuilder == null) {
            this.populateStyleProperties();
            this.setBackgroundStyleString();
        }
        if (StringUtils.isEmpty((CharSequence)(style = this.styleBuilder.toString()))) {
            return null;
        }
        return style;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.itemModels == null) {
            this.itemModels = this.getItemModels(this.request, ComponentExporter.class);
        }
        return this.itemModels;
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            Map<String, ? extends ComponentExporter> models = this.getExportedItems();
            this.exportedItemsOrder = !models.isEmpty() ? models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    protected Map<String, ComponentExporter> getItemModels(@NotNull SlingHttpServletRequest request, @NotNull Class<ComponentExporter> modelClass) {
        LinkedHashMap<String, ComponentExporter> models = new LinkedHashMap<String, ComponentExporter>();
        this.getFilteredChildren().forEach(child -> {
            ComponentExporter model = (ComponentExporter)this.modelFactory.getModelFromWrappedRequest(request, child, modelClass);
            if (model != null) {
                models.put(child.getName(), model);
            }
        });
        return models;
    }
}

