/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.BreadcrumbItemImpl;
import com.adobe.cq.wcm.core.components.models.Breadcrumb;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Breadcrumb.class, ComponentExporter.class}, resourceType={"core/wcm/components/breadcrumb/v1/breadcrumb", "core/wcm/components/breadcrumb/v2/breadcrumb"})
@Exporter(name="jackson", extensions={"json"})
public class BreadcrumbImpl
implements Breadcrumb {
    protected static final String RESOURCE_TYPE_V1 = "core/wcm/components/breadcrumb/v1/breadcrumb";
    protected static final String RESOURCE_TYPE_V2 = "core/wcm/components/breadcrumb/v2/breadcrumb";
    protected static final boolean PROP_SHOW_HIDDEN_DEFAULT = false;
    protected static final boolean PROP_HIDE_CURRENT_DEFAULT = false;
    protected static final int PROP_START_LEVEL_DEFAULT = 2;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @ScriptVariable
    private Page currentPage;
    @Self
    private SlingHttpServletRequest request;
    private boolean showHidden;
    private boolean hideCurrent;
    private int startLevel;
    private List<NavigationItem> items;

    @PostConstruct
    private void initModel() {
        this.startLevel = (Integer)this.properties.get("startLevel", this.currentStyle.get("startLevel", (Object)2));
        this.showHidden = (Boolean)this.properties.get("showHidden", this.currentStyle.get("showHidden", (Object)false));
        this.hideCurrent = (Boolean)this.properties.get("hideCurrent", this.currentStyle.get("hideCurrent", (Object)false));
    }

    @Override
    public Collection<NavigationItem> getItems() {
        if (this.items == null) {
            this.items = this.createItems();
        }
        return this.items;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    private List<NavigationItem> createItems() {
        ArrayList<NavigationItem> items = new ArrayList<NavigationItem>();
        int currentLevel = this.currentPage.getDepth();
        while (this.startLevel < currentLevel) {
            Page page = this.currentPage.getAbsoluteParent(this.startLevel);
            if (page != null) {
                boolean isActivePage = page.equals(this.currentPage);
                if (isActivePage && this.hideCurrent) break;
                if (this.checkIfNotHidden(page)) {
                    BreadcrumbItemImpl navigationItem = new BreadcrumbItemImpl(page, isActivePage, this.request, currentLevel, Collections.emptyList());
                    items.add(navigationItem);
                }
            }
            ++this.startLevel;
        }
        return items;
    }

    private boolean checkIfNotHidden(Page page) {
        return !page.isHideInNav() || this.showHidden;
    }
}

