/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.Image;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Source;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v1/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
implements Image {
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v1/image";
    private static final String DEFAULT_EXTENSION = "jpeg";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    protected static final String DOT = ".";
    protected static final String MIME_TYPE_IMAGE_JPEG = "image/jpeg";
    protected static final String MIME_TYPE_IMAGE_SVG = "image/svg+xml";
    private static final String MIME_TYPE_IMAGE_PREFIX = "image/";
    @Self
    protected SlingHttpServletRequest request;
    @Inject
    protected Resource resource;
    @ScriptVariable
    protected PageManager pageManager;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    protected Style currentStyle;
    @ScriptVariable
    protected ValueMap properties;
    @Inject
    @Source(value="osgi-services")
    protected MimeTypeService mimeTypeService;
    @ValueMapValue(name="fileReference", injectionStrategy=InjectionStrategy.OPTIONAL)
    protected String fileReference;
    @ValueMapValue(name="alt", injectionStrategy=InjectionStrategy.OPTIONAL)
    protected String alt;
    @ValueMapValue(name="jcr:title", injectionStrategy=InjectionStrategy.OPTIONAL)
    protected String title;
    @ValueMapValue(name="linkURL", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String linkURL;
    protected String src;
    protected String[] smartImages = new String[0];
    protected int[] smartSizes = new int[0];
    protected String json;
    protected boolean displayPopupTitle;
    protected boolean isDecorative;
    protected boolean hasContent;
    protected String mimeType;
    protected String selector = "img";
    protected String extension;
    protected long lastModifiedDate = 0L;
    protected boolean inTemplate;
    protected String baseResourcePath;
    protected String templateRelativePath;
    protected boolean disableLazyLoading;
    protected int jpegQuality;
    protected String imageName;

    @PostConstruct
    protected void initModel() {
        this.mimeType = MIME_TYPE_IMAGE_JPEG;
        this.displayPopupTitle = (Boolean)this.properties.get("displayPopupTitle", this.currentStyle.get("displayPopupTitle", (Object)false));
        this.isDecorative = (Boolean)this.properties.get("isDecorative", this.currentStyle.get("isDecorative", (Object)false));
        Asset asset = null;
        if (StringUtils.isNotEmpty((CharSequence)this.fileReference)) {
            Resource assetResource = this.request.getResourceResolver().getResource(this.fileReference);
            if (assetResource != null) {
                asset = (Asset)assetResource.adaptTo(Asset.class);
                if (asset != null) {
                    this.mimeType = PropertiesUtil.toString((Object)asset.getMimeType(), (String)MIME_TYPE_IMAGE_JPEG);
                    this.imageName = this.getImageNameFromDam();
                    this.hasContent = true;
                } else {
                    LOGGER.error("Unable to adapt resource '{}' used by image '{}' to an asset.", (Object)this.fileReference, (Object)this.resource.getPath());
                }
            } else {
                LOGGER.error("Unable to find resource '{}' used by image '{}'.", (Object)this.fileReference, (Object)this.resource.getPath());
            }
        } else {
            Resource file = this.resource.getChild("file");
            if (file != null) {
                this.mimeType = PropertiesUtil.toString((Object)file.getResourceMetadata().get((Object)"sling.contentType"), (String)MIME_TYPE_IMAGE_JPEG);
                String fileName = (String)this.properties.get("fileName", String.class);
                this.imageName = StringUtils.isNotEmpty((CharSequence)fileName) ? this.getSeoFriendlyName(FilenameUtils.getBaseName((String)fileName)) : "";
                this.hasContent = true;
            }
        }
        if (this.hasContent) {
            long assetLastModifiedDate;
            if (!this.mimeType.startsWith(MIME_TYPE_IMAGE_PREFIX)) {
                LOGGER.error("Image at {} uses a binary with a non-image mime type ({})", (Object)this.resource.getPath(), (Object)this.mimeType);
                this.hasContent = false;
                return;
            }
            this.mimeType = this.mimeType.split(";")[0];
            this.extension = this.mimeTypeService.getExtension(this.mimeType);
            ValueMap properties = this.resource.getValueMap();
            Calendar lastModified = (Calendar)properties.get("jcr:lastModified", Calendar.class);
            if (lastModified == null) {
                lastModified = (Calendar)properties.get("cq:lastModified", Calendar.class);
            }
            if (lastModified != null) {
                this.lastModifiedDate = lastModified.getTimeInMillis();
            }
            if (asset != null && (assetLastModifiedDate = asset.getLastModified()) > this.lastModifiedDate) {
                this.lastModifiedDate = assetLastModifiedDate;
            }
            if (this.extension == null || this.extension.equalsIgnoreCase("tif") || this.extension.equalsIgnoreCase("tiff")) {
                this.extension = DEFAULT_EXTENSION;
            }
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)false);
            this.jpegQuality = (Integer)this.currentStyle.get("jpegQuality", (Object)82);
            int index = 0;
            Template template = this.currentPage.getTemplate();
            if (template != null && this.resource.getPath().startsWith(template.getPath())) {
                this.inTemplate = true;
                this.baseResourcePath = this.currentPage.getPath();
                this.templateRelativePath = this.resource.getPath().substring(template.getPath().length());
            } else {
                this.baseResourcePath = this.resource.getPath();
            }
            this.baseResourcePath = this.resource.getResourceResolver().map((HttpServletRequest)this.request, this.baseResourcePath);
            if (this.smartSizesSupported()) {
                Set<Integer> supportedRenditionWidths = this.getSupportedRenditionWidths();
                this.smartImages = new String[supportedRenditionWidths.size()];
                this.smartSizes = new int[supportedRenditionWidths.size()];
                for (Integer width : supportedRenditionWidths) {
                    this.smartImages[index] = this.baseResourcePath + DOT + this.selector + DOT + this.jpegQuality + DOT + width + DOT + this.extension + (this.inTemplate ? Text.escapePath((String)this.templateRelativePath) : "") + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") + DOT + this.extension : "");
                    this.smartSizes[index] = width;
                    ++index;
                }
            } else {
                this.smartImages = new String[0];
                this.smartSizes = new int[0];
            }
            this.src = this.baseResourcePath + DOT + this.selector + DOT;
            this.src = this.smartSizes.length == 1 ? this.src + this.jpegQuality + DOT + this.smartSizes[0] + DOT + this.extension : this.src + this.extension;
            this.src = this.src + (this.inTemplate ? Text.escapePath((String)this.templateRelativePath) : "") + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") + DOT + this.extension : "");
            if (!this.isDecorative) {
                if (StringUtils.isNotEmpty((CharSequence)this.linkURL)) {
                    this.linkURL = Utils.getURL(this.request, this.pageManager, this.linkURL);
                }
            } else {
                this.linkURL = null;
                this.alt = null;
            }
            this.buildJson();
        }
    }

    protected String getImageNameFromDam() {
        String imageName = "";
        Resource damResource = this.request.getResourceResolver().getResource(this.fileReference);
        if (damResource != null) {
            Asset asset = (Asset)damResource.adaptTo(Asset.class);
            imageName = asset != null ? StringUtils.trimToNull((String)asset.getName()) : "";
        }
        return this.getSeoFriendlyName(FilenameUtils.getBaseName((String)imageName));
    }

    protected String getSeoFriendlyName(String imageName) {
        String seoFriendlyName = imageName.replaceAll("[\\ _]", "-").toLowerCase();
        try {
            seoFriendlyName = URLEncoder.encode(seoFriendlyName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(String.format("The Character Encoding is not supported.", new Object[0]));
        }
        return seoFriendlyName;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public boolean displayPopupTitle() {
        return this.displayPopupTitle;
    }

    @Override
    public String getAlt() {
        return this.alt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getLink() {
        return this.linkURL;
    }

    @Override
    @JsonIgnore
    public String getFileReference() {
        return this.fileReference;
    }

    @Override
    @JsonIgnore
    public String getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    protected void buildJson() {
        JsonArrayBuilder smartSizesJsonBuilder = Json.createArrayBuilder();
        for (int size : this.smartSizes) {
            smartSizesJsonBuilder.add(size);
        }
        JsonArrayBuilder smartImagesJsonBuilder = Json.createArrayBuilder();
        for (String image : this.smartImages) {
            smartImagesJsonBuilder.add(image);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("smartImages", smartImagesJsonBuilder);
        jsonObjectBuilder.add("smartSizes", smartSizesJsonBuilder);
        jsonObjectBuilder.add("lazyEnabled", !this.disableLazyLoading);
        this.json = jsonObjectBuilder.build().toString();
    }

    private Set<Integer> getSupportedRenditionWidths() {
        String[] supportedWidthsConfig;
        TreeSet<Integer> allowedRenditionWidths = new TreeSet<Integer>();
        for (String width : supportedWidthsConfig = (String[])this.currentStyle.get("allowedRenditionWidths", (Object)new String[0])) {
            try {
                allowedRenditionWidths.add(Integer.parseInt(width));
            }
            catch (NumberFormatException e) {
                LOGGER.error(String.format("Invalid width detected (%s) for content policy configuration.", width), (Throwable)e);
            }
        }
        return allowedRenditionWidths;
    }

    private boolean smartSizesSupported() {
        return !StringUtils.equals((CharSequence)this.mimeType, (CharSequence)MIME_TYPE_IMAGE_SVG);
    }
}

