/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.models.v1.NavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.LanguageNavigationItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import java.util.List;
import java.util.Locale;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageNavigationItemImpl
extends NavigationItemImpl
implements LanguageNavigationItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageNavigationItemImpl.class);
    protected String title;
    protected Locale locale;
    protected String country;
    protected String language;

    public LanguageNavigationItemImpl(Page page, boolean active, SlingHttpServletRequest request, int level, List<NavigationItem> children, String title) {
        super(page, active, request, level, children);
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.page.getLanguage(false);
        }
        return this.locale;
    }

    @Override
    public String getCountry() {
        if (this.country == null) {
            this.country = this.page.getLanguage(false).getCountry();
        }
        return this.country;
    }

    @Override
    public String getLanguage() {
        if (this.language == null) {
            this.language = this.page.getLanguage(false).toString().replace('_', '-');
        }
        return this.language;
    }
}

