/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractContainerImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.PanelContainerItemImpl;
import com.adobe.cq.wcm.core.components.models.Container;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

public class PanelContainerImpl
extends AbstractContainerImpl
implements Container {
    @Override
    protected List<ListItem> readItems() {
        LinkedList<ListItem> items = new LinkedList<ListItem>();
        this.getChildren().forEach(res -> items.add(new PanelContainerItemImpl(this.request, (Resource)res)));
        return items;
    }

    @Override
    protected Map<String, ComponentExporter> getItemModels(@NotNull SlingHttpServletRequest request, @NotNull Class<ComponentExporter> modelClass) {
        Map<String, ComponentExporter> models = super.getItemModels(request, modelClass);
        models.entrySet().forEach(entry -> {
            ListItem match = this.getItems().stream().filter(item -> item != null && StringUtils.isNotEmpty((CharSequence)item.getName()) && StringUtils.equals((CharSequence)item.getName(), (CharSequence)((CharSequence)entry.getKey()))).findFirst().get();
            if (match != null) {
                entry.setValue(new JsonWrapper((ComponentExporter)entry.getValue(), match));
            }
        });
        return models;
    }

    static class JsonWrapper
    implements ComponentExporter {
        private ComponentExporter inner;
        private String panelTitle;

        JsonWrapper(@NotNull ComponentExporter inner, ListItem item) {
            this.inner = inner;
            this.panelTitle = item.getTitle();
        }

        @JsonUnwrapped
        public ComponentExporter getInner() {
            return this.inner;
        }

        @JsonProperty(value="cq:panelTitle")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        public String getPanelTitle() {
            return this.panelTitle;
        }

        @NotNull
        public String getExportedType() {
            if (this.inner != null) {
                return this.inner.getExportedType();
            }
            return "";
        }
    }
}

