/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Search;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Search.class, ComponentExporter.class}, resourceType={"core/wcm/components/search/v1/search"})
@Exporter(name="jackson", extensions={"json"})
public class SearchImpl
implements Search {
    protected static final String RESOURCE_TYPE = "core/wcm/components/search/v1/search";
    public static final int PROP_RESULTS_SIZE_DEFAULT = 10;
    public static final int PROP_SEARCH_TERM_MINIMUM_LENGTH_DEFAULT = 3;
    public static final String PROP_SEARCH_ROOT_DEFAULT = "/content";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    private String relativePath;
    private int resultsSize;
    private int searchTermMinimumLength;

    @PostConstruct
    private void initModel() {
        Page containingPage;
        this.resultsSize = (Integer)this.currentStyle.get("resultsSize", (Object)10);
        this.searchTermMinimumLength = (Integer)this.currentStyle.get("searchTermMinimumLength", (Object)3);
        PageManager pageManager = this.currentPage.getPageManager();
        Resource currentResource = this.request.getResource();
        if (pageManager != null && (containingPage = pageManager.getContainingPage(currentResource)) != null) {
            this.relativePath = StringUtils.substringAfter((String)currentResource.getPath(), (String)containingPage.getPath());
        }
    }

    @Override
    public int getResultsSize() {
        return this.resultsSize;
    }

    @Override
    public int getSearchTermMinimumLength() {
        return this.searchTermMinimumLength;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }
}

