/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.CommerceHelper;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.SocialMediaHelper;
import com.adobe.cq.xf.social.ExperienceFragmentSocialVariation;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.ImageResource;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={SocialMediaHelper.class, ComponentExporter.class}, resourceType={"core/wcm/components/sharing/v1/sharing"})
@Exporter(name="jackson", extensions={"json"})
public class SocialMediaHelperImpl
implements SocialMediaHelper {
    static final String RESOURCE_TYPE = "core/wcm/components/sharing/v1/sharing";
    private static final Logger LOGGER = LoggerFactory.getLogger(SocialMediaHelperImpl.class);
    static final String OG_TITLE = "og:title";
    static final String OG_URL = "og:url";
    static final String OG_TYPE = "og:type";
    static final String OG_SITE_NAME = "og:site_name";
    static final String OG_IMAGE = "og:image";
    static final String OG_DESCRIPTION = "og:description";
    static final String OG_PRODUCT_PRICE_AMOUNT = "product:price:amount";
    static final String OG_PRODUCT_PRICE_CURRENCY = "product:price:currency";
    @ScriptVariable
    private Page currentPage = null;
    @Self
    private SlingHttpServletRequest request = null;
    @ScriptVariable
    private SlingHttpServletResponse response = null;
    @SlingObject
    private ResourceResolver resourceResolver = null;
    @OSGiService
    private Externalizer externalizer = null;
    private Boolean hasSharingComponent;
    private boolean facebookEnabled;
    private boolean pinterestEnabled;
    private boolean socialMediaEnabled;
    private String variantPath;
    private Map<String, String> metadata;

    @Override
    public boolean isFacebookEnabled() {
        return this.facebookEnabled;
    }

    @Override
    public boolean isPinterestEnabled() {
        return this.pinterestEnabled;
    }

    @Override
    public boolean isSocialMediaEnabled() {
        return this.socialMediaEnabled;
    }

    @Override
    @JsonProperty(value="hasFacebookSharing")
    public boolean hasFacebookSharing() {
        return this.facebookEnabled && this.hasSharingComponent();
    }

    @Override
    @JsonProperty(value="hasPinteresSharing")
    public boolean hasPinterestSharing() {
        return this.pinterestEnabled && this.hasSharingComponent();
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.initMetadata();
        }
        return this.metadata;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @PostConstruct
    private void initModel() throws Exception {
        ValueMap pageProperties = this.currentPage.getProperties();
        Object[] socialMedia = (String[])pageProperties.get("socialMedia", String[].class);
        this.facebookEnabled = ArrayUtils.contains((Object[])socialMedia, (Object)"facebook");
        this.pinterestEnabled = ArrayUtils.contains((Object[])socialMedia, (Object)"pinterest");
        this.socialMediaEnabled = this.facebookEnabled || this.pinterestEnabled;
        this.variantPath = (String)pageProperties.get("variantPath", String.class);
    }

    private boolean hasSharingComponent() {
        if (this.hasSharingComponent == null) {
            this.hasSharingComponent = this.hasSharingComponent(this.currentPage.getContentResource());
        }
        return this.hasSharingComponent;
    }

    private boolean hasSharingComponent(Resource resource) {
        if (resource.isResourceType(RESOURCE_TYPE)) {
            return true;
        }
        for (Resource child : resource.getChildren()) {
            if (!this.hasSharingComponent(child)) continue;
            return true;
        }
        return false;
    }

    private void initMetadata() {
        this.metadata = new LinkedHashMap<String, String>();
        if (this.socialMediaEnabled) {
            WebsiteMetadata websiteMetadata = this.createMetadataProvider();
            this.put(OG_TITLE, websiteMetadata.getTitle());
            this.put(OG_URL, websiteMetadata.getURL());
            this.put(OG_TYPE, websiteMetadata.getTypeName());
            this.put(OG_SITE_NAME, websiteMetadata.getSiteName());
            this.put(OG_IMAGE, websiteMetadata.getImage());
            this.put(OG_DESCRIPTION, websiteMetadata.getDescription());
            if (this.pinterestEnabled && websiteMetadata instanceof ProductMetadata) {
                ProductMetadata productMetadata = (ProductMetadata)websiteMetadata;
                this.put(OG_PRODUCT_PRICE_AMOUNT, productMetadata.getProductPriceAmount());
                this.put(OG_PRODUCT_PRICE_CURRENCY, productMetadata.getProductPriceCurrency());
            }
        }
    }

    private void put(String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.metadata.put(name, value);
        }
    }

    private WebsiteMetadata createMetadataProvider() {
        try {
            Product product = CommerceHelper.findCurrentProduct((Page)this.currentPage);
            ExperienceFragmentSocialVariation smVariant = this.findExperienceFragmentSocialVariation();
            if (product == null) {
                if (smVariant == null) {
                    return new WebsiteMetadataProvider();
                }
                return new ExperienceFragmentWebsiteMetadataProvider(smVariant);
            }
            if (smVariant == null) {
                return new ProductMetadataProvider(product);
            }
            return new ExperienceFragmentProductMetadataProvider(product, smVariant);
        }
        catch (NoClassDefFoundError e) {
            return new WebsiteMetadataProvider();
        }
    }

    private ExperienceFragmentSocialVariation findExperienceFragmentSocialVariation() {
        Page variantPage = this.currentPage.getPageManager().getPage(this.variantPath);
        if (variantPage == null) {
            return null;
        }
        ExperienceFragmentSocialVariation socialVariant = (ExperienceFragmentSocialVariation)variantPage.adaptTo(ExperienceFragmentSocialVariation.class);
        return socialVariant;
    }

    private class ExperienceFragmentProductMetadataProvider
    extends ProductMetadataProvider {
        private final ExperienceFragmentMetadataProvider xfMetadata;

        public ExperienceFragmentProductMetadataProvider(Product product, ExperienceFragmentSocialVariation variation) {
            super(product);
            this.xfMetadata = new ExperienceFragmentMetadataProvider(variation);
        }

        @Override
        public String getDescription() {
            return this.xfMetadata.getDescription(super.getDescription());
        }

        @Override
        public String getImage() {
            return this.xfMetadata.getImage(super.getImage());
        }
    }

    private class ExperienceFragmentWebsiteMetadataProvider
    extends WebsiteMetadataProvider {
        private final ExperienceFragmentMetadataProvider xfMetadata;

        public ExperienceFragmentWebsiteMetadataProvider(ExperienceFragmentSocialVariation variation) {
            this.xfMetadata = new ExperienceFragmentMetadataProvider(variation);
        }

        @Override
        public String getDescription() {
            return this.xfMetadata.getDescription(super.getDescription());
        }

        @Override
        public String getImage() {
            return this.xfMetadata.getImage(super.getImage());
        }
    }

    private class ExperienceFragmentMetadataProvider {
        private ExperienceFragmentSocialVariation variation;

        public ExperienceFragmentMetadataProvider(ExperienceFragmentSocialVariation variation) {
            this.variation = variation;
        }

        public String getDescription(String defaultDescription) {
            if (this.variation == null) {
                return defaultDescription;
            }
            String description = this.variation.getText();
            if (StringUtils.isNotBlank((CharSequence)description)) {
                return description;
            }
            return defaultDescription;
        }

        public String getImage(String defaultImage) {
            if (this.variation == null) {
                return defaultImage;
            }
            String image = this.variation.getImagePath();
            if (StringUtils.isNotBlank((CharSequence)image)) {
                image = SocialMediaHelperImpl.this.externalizer.publishLink(SocialMediaHelperImpl.this.resourceResolver, image);
                return image;
            }
            return defaultImage;
        }
    }

    private class ProductMetadataProvider
    extends WebsiteMetadataProvider
    implements ProductMetadata {
        private Product product;
        private PriceInfo priceInfo;

        public ProductMetadataProvider(Product product) {
            this.product = product;
        }

        @Override
        public String getTitle() {
            String title = this.product.getTitle();
            if (StringUtils.isBlank((CharSequence)title)) {
                title = super.getTitle();
            }
            return title;
        }

        @Override
        public WebsiteMetadata.Type getType() {
            return WebsiteMetadata.Type.product;
        }

        @Override
        public String getImage() {
            ImageResource imageResource = this.product.getImage();
            if (imageResource == null) {
                return super.getImage();
            }
            String image = imageResource.getFileReference();
            image = StringUtils.isBlank((CharSequence)image) ? super.getImage() : SocialMediaHelperImpl.this.externalizer.publishLink(SocialMediaHelperImpl.this.resourceResolver, image);
            return image;
        }

        @Override
        public String getDescription() {
            String description = this.product.getDescription();
            if (StringUtils.isBlank((CharSequence)description)) {
                description = super.getDescription();
            }
            return description;
        }

        @Override
        public String getProductPriceAmount() {
            String amount = null;
            try {
                this.initPriceInfo();
                if (this.priceInfo != null) {
                    amount = String.valueOf(this.priceInfo.getAmount());
                }
            }
            catch (CommerceException x) {
                LOGGER.error("Error getting product price amount", (Throwable)x);
            }
            return amount;
        }

        @Override
        public String getProductPriceCurrency() {
            String currency = null;
            try {
                this.initPriceInfo();
                if (this.priceInfo != null) {
                    currency = this.priceInfo.getCurrency().getCurrencyCode();
                }
            }
            catch (CommerceException x) {
                LOGGER.error("Error getting product price currency", (Throwable)x);
            }
            return currency;
        }

        private void initPriceInfo() throws CommerceException {
            CommerceSession commerceSession;
            List priceInfoList;
            CommerceService commerceService;
            Resource productResource = SocialMediaHelperImpl.this.resourceResolver.getResource(this.product.getPath());
            if (productResource != null && (commerceService = (CommerceService)productResource.adaptTo(CommerceService.class)) != null && !(priceInfoList = (commerceSession = commerceService.login(SocialMediaHelperImpl.this.request, SocialMediaHelperImpl.this.response)).getProductPriceInfo(this.product, (Predicate)new PriceFilter(new String[]{"UNIT"}))).isEmpty()) {
                this.priceInfo = (PriceInfo)priceInfoList.get(0);
            }
        }
    }

    private class WebsiteMetadataProvider
    implements WebsiteMetadata {
        private static final String PN_IMAGE_FILE_JCR_CONTENT = "image/file/jcr:content";

        private WebsiteMetadataProvider() {
        }

        @Override
        public String getTitle() {
            String title = SocialMediaHelperImpl.this.currentPage.getTitle();
            if (StringUtils.isBlank((CharSequence)title)) {
                title = SocialMediaHelperImpl.this.currentPage.getName();
            }
            return title;
        }

        @Override
        public String getURL() {
            String pagePath = SocialMediaHelperImpl.this.currentPage.getPath();
            String extension = SocialMediaHelperImpl.this.request.getRequestPathInfo().getExtension();
            String url = SocialMediaHelperImpl.this.externalizer.publishLink(SocialMediaHelperImpl.this.resourceResolver, pagePath) + "." + extension;
            return url;
        }

        @Override
        public WebsiteMetadata.Type getType() {
            return WebsiteMetadata.Type.website;
        }

        @Override
        public String getTypeName() {
            return this.getType().name();
        }

        @Override
        public String getImage() {
            String image = this.getThumbnailUrl(SocialMediaHelperImpl.this.currentPage, 800, 480);
            image = SocialMediaHelperImpl.this.externalizer.publishLink(SocialMediaHelperImpl.this.resourceResolver, image);
            return image;
        }

        private String getThumbnailUrl(Page page, int width, int height) {
            String ck = "";
            ValueMap metadata = page.getProperties(PN_IMAGE_FILE_JCR_CONTENT);
            if (metadata != null) {
                Calendar imageLastModified = (Calendar)metadata.get("jcr:lastModified", Calendar.class);
                Calendar pageLastModified = page.getLastModified();
                if (pageLastModified != null && pageLastModified.after(imageLastModified)) {
                    ck = ck + pageLastModified.getTimeInMillis() / 1000L;
                } else if (imageLastModified != null) {
                    ck = ck + imageLastModified.getTimeInMillis() / 1000L;
                } else if (pageLastModified != null) {
                    ck = ck + pageLastModified.getTimeInMillis() / 1000L;
                }
            }
            return page.getPath() + ".thumb." + width + "." + height + ".png?ck=" + ck;
        }

        @Override
        public String getDescription() {
            return SocialMediaHelperImpl.this.currentPage.getDescription();
        }

        @Override
        public String getSiteName() {
            Page page = this.findRootPage();
            String pageTitle = page.getPageTitle();
            if (StringUtils.isNotBlank((CharSequence)pageTitle)) {
                return pageTitle;
            }
            Resource content = page.getContentResource();
            if (content == null) {
                return null;
            }
            String title = (String)content.getValueMap().get("jcr:title", String.class);
            if (StringUtils.isBlank((CharSequence)title)) {
                return null;
            }
            return title;
        }

        private Page findRootPage() {
            Page page = SocialMediaHelperImpl.this.currentPage;
            Page parent;
            while ((parent = page.getParent()) != null) {
                page = parent;
            }
            return page;
        }
    }

    private static interface ProductMetadata
    extends WebsiteMetadata {
        public String getProductPriceAmount();

        public String getProductPriceCurrency();
    }

    private static interface WebsiteMetadata {
        public String getTitle();

        public String getURL();

        public Type getType();

        public String getTypeName();

        public String getImage();

        public String getDescription();

        public String getSiteName();

        public static enum Type {
            website,
            product;

        }
    }
}

