/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractImageDelegatingModel;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Teaser.class, ComponentExporter.class}, resourceType={"core/wcm/components/teaser/v1/teaser"})
@Exporter(name="jackson", extensions={"json"})
public class TeaserImpl
extends AbstractImageDelegatingModel
implements Teaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeaserImpl.class);
    public static final String RESOURCE_TYPE = "core/wcm/components/teaser/v1/teaser";
    private String title;
    private String description;
    private String linkURL;
    private String titleType;
    private boolean actionsEnabled = false;
    private boolean titleHidden = false;
    private boolean descriptionHidden = false;
    private boolean imageLinkHidden = false;
    private boolean titleLinkHidden = false;
    private boolean titleFromPage = false;
    private boolean descriptionFromPage = false;
    private List<ListItem> actions = new ArrayList<ListItem>();
    private final List<String> hiddenImageResourceProperties = new ArrayList<String>(){
        {
            this.add("jcr:title");
            this.add("jcr:description");
        }
    };
    @ScriptVariable
    private Component component;
    @Inject
    private Resource resource;
    @ScriptVariable
    private PageManager pageManager;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    protected Style currentStyle;
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private ModelFactory modelFactory;
    private Page targetPage;
    private Image image;

    @PostConstruct
    private void initModel() {
        ValueMap properties = this.resource.getValueMap();
        this.actionsEnabled = (Boolean)properties.get("actionsEnabled", (Object)this.actionsEnabled);
        this.populateStyleProperties();
        this.titleFromPage = (Boolean)properties.get("titleFromPage", (Object)this.titleFromPage);
        this.descriptionFromPage = (Boolean)properties.get("descriptionFromPage", (Object)this.descriptionFromPage);
        this.linkURL = (String)properties.get("linkURL", String.class);
        if (this.actionsEnabled) {
            ListItem firstAction;
            this.hiddenImageResourceProperties.add("linkURL");
            this.linkURL = null;
            this.populateActions();
            if (this.actions.size() > 0 && (firstAction = this.actions.get(0)) != null) {
                this.targetPage = this.pageManager.getPage(firstAction.getPath());
            }
        } else {
            this.targetPage = this.pageManager.getPage(this.linkURL);
        }
        if (this.titleHidden) {
            this.title = null;
        } else {
            this.title = (String)properties.get("jcr:title", String.class);
            if (this.titleFromPage) {
                this.title = this.targetPage != null ? (String)StringUtils.defaultIfEmpty((CharSequence)this.targetPage.getPageTitle(), (CharSequence)this.targetPage.getTitle()) : null;
            }
        }
        if (this.descriptionHidden) {
            this.description = null;
        } else {
            this.description = (String)properties.get("jcr:description", String.class);
            if (this.descriptionFromPage) {
                this.description = this.targetPage != null ? this.targetPage.getDescription() : null;
            }
        }
        String fileReference = (String)properties.get("fileReference", String.class);
        boolean hasImage = true;
        if (StringUtils.isEmpty((CharSequence)this.linkURL)) {
            LOGGER.debug("Teaser component from " + this.request.getResource().getPath() + " does not define a link.");
        }
        if (StringUtils.isEmpty((CharSequence)fileReference)) {
            if (this.request.getResource().getChild("file") == null) {
                LOGGER.debug("Teaser component from " + this.request.getResource().getPath() + " does not have an asset or an image file configured.");
                hasImage = false;
            }
        } else if (this.request.getResourceResolver().getResource(fileReference) == null) {
            LOGGER.error("Asset " + fileReference + " configured for the teaser component from " + this.request.getResource().getPath() + " doesn't exist.");
            hasImage = false;
        }
        if (hasImage) {
            this.setImageResource(this.component, this.request.getResource(), this.hiddenImageResourceProperties);
        }
        if (this.targetPage != null) {
            this.linkURL = Utils.getURL(this.request, this.targetPage);
        }
    }

    private void populateStyleProperties() {
        if (this.currentStyle != null) {
            this.titleHidden = (Boolean)this.currentStyle.get("titleHidden", (Object)this.titleHidden);
            this.descriptionHidden = (Boolean)this.currentStyle.get("descriptionHidden", (Object)this.descriptionHidden);
            this.titleType = (String)this.currentStyle.get("titleType", (Object)this.titleType);
            this.imageLinkHidden = (Boolean)this.currentStyle.get("imageLinkHidden", (Object)this.imageLinkHidden);
            this.titleLinkHidden = (Boolean)this.currentStyle.get("titleLinkHidden", (Object)this.titleLinkHidden);
            if (this.imageLinkHidden) {
                this.hiddenImageResourceProperties.add("linkURL");
            }
            if (((Boolean)this.currentStyle.get("actionsDisabled", (Object)false)).booleanValue()) {
                this.actionsEnabled = false;
            }
        }
    }

    private void populateActions() {
        Resource actionsNode = this.resource.getChild("actions");
        if (actionsNode != null) {
            for (final Resource action : actionsNode.getChildren()) {
                this.actions.add(new ListItem(){
                    private ValueMap properties;
                    private String title;
                    private String url;
                    private Page page;
                    {
                        this.properties = action.getValueMap();
                        this.title = (String)this.properties.get("text", String.class);
                        this.url = (String)this.properties.get("link", String.class);
                        this.page = null;
                        if (this.url != null && this.url.startsWith("/")) {
                            this.page = TeaserImpl.this.pageManager.getPage(this.url);
                        }
                    }

                    @Override
                    @Nullable
                    public String getTitle() {
                        return this.title;
                    }

                    @Override
                    @JsonIgnore
                    @Nullable
                    public String getPath() {
                        return this.url;
                    }

                    @Override
                    @Nullable
                    public String getURL() {
                        if (this.page != null) {
                            return Utils.getURL(TeaserImpl.this.request, this.page);
                        }
                        return this.url;
                    }
                });
            }
        }
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    @Override
    public List<ListItem> getActions() {
        return this.actions;
    }

    @Override
    public String getLinkURL() {
        return this.linkURL;
    }

    public String getImagePath() {
        if (this.image != null) {
            return this.image.getSrc();
        }
        final Resource imageResource = this.getImageResource();
        if (imageResource != null) {
            SlingHttpServletRequestWrapper wrappedRequest = new SlingHttpServletRequestWrapper(this.request){

                @NotNull
                public Resource getResource() {
                    return imageResource;
                }
            };
            this.image = (Image)this.modelFactory.getModelFromRequest((SlingHttpServletRequest)wrappedRequest);
            if (this.image != null) {
                return this.image.getSrc();
            }
        }
        return null;
    }

    @Override
    public boolean isImageLinkHidden() {
        return this.imageLinkHidden;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isTitleLinkHidden() {
        return this.titleLinkHidden;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitleType() {
        Utils.Heading heading = Utils.Heading.getHeading(this.titleType);
        if (heading != null) {
            return heading.getElement();
        }
        return null;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }
}

