/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.RedirectItemImpl;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.models.Page;
import com.adobe.granite.license.ProductInfoProvider;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.day.cq.wcm.api.components.ComponentContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Page.class, ContainerExporter.class}, resourceType={"core/wcm/components/page/v2/page"})
@Exporter(name="jackson", extensions={"json"})
public class PageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.PageImpl
implements Page {
    protected static final String RESOURCE_TYPE = "core/wcm/components/page/v2/page";
    protected static final String PN_CLIENTLIBS_JS_HEAD = "clientlibsJsHead";
    public static final String PN_REDIRECT_TARGET = "cq:redirectTarget";
    private Boolean hasCloudconfigSupport;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    private ProductInfoProvider productInfoProvider;
    @Self
    protected SlingHttpServletRequest request;
    @ScriptVariable
    private ComponentContext componentContext;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="cq:redirectTarget")
    private String redirectTargetValue;
    private String appResourcesPath;
    private NavigationItem redirectTarget;
    protected String[] clientLibCategoriesJsBody = new String[0];
    protected String[] clientLibCategoriesJsHead = new String[0];

    @Override
    @PostConstruct
    protected void initModel() {
        Collection clientLibraries;
        ArrayList clientLibraryList;
        super.initModel();
        String resourcesClientLibrary = (String)this.currentStyle.get("appResourcesClientlib", String.class);
        if (resourcesClientLibrary != null && !(clientLibraryList = Lists.newArrayList((clientLibraries = this.htmlLibraryManager.getLibraries(new String[]{resourcesClientLibrary}, LibraryType.CSS, true, true)).iterator())).isEmpty()) {
            this.appResourcesPath = this.getProxyPath((ClientLibrary)clientLibraryList.get(0));
        }
        this.populateClientLibCategoriesJs();
        this.setRedirect();
    }

    private void setRedirect() {
        if (StringUtils.isNotEmpty((CharSequence)this.redirectTargetValue)) {
            this.redirectTarget = new RedirectItemImpl(this.redirectTargetValue, this.request);
        }
    }

    private String getProxyPath(ClientLibrary lib) {
        String path = lib.getPath();
        if (lib.allowProxy()) {
            for (String searchPath : this.request.getResourceResolver().getSearchPath()) {
                if (!path.startsWith(searchPath)) continue;
                path = this.request.getContextPath() + "/etc.clientlibs/" + path.replaceFirst(searchPath, "");
            }
        } else if (this.request.getResourceResolver().getResource(lib.getPath()) == null) {
            path = null;
        }
        if (path != null) {
            path = path + "/resources";
        }
        return path;
    }

    protected void populateClientLibCategoriesJs() {
        if (this.currentStyle != null) {
            this.clientLibCategoriesJsHead = (String[])this.currentStyle.get(PN_CLIENTLIBS_JS_HEAD, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
            LinkedHashSet<String> categories = new LinkedHashSet<String>(Arrays.asList(this.clientLibCategories));
            categories.removeAll(Arrays.asList(this.clientLibCategoriesJsHead));
            this.clientLibCategoriesJsBody = categories.toArray(new String[0]);
        }
    }

    @Override
    protected void loadFavicons(String designPath) {
    }

    @Override
    @JsonIgnore
    public Map<String, String> getFavicons() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsBody() {
        return Arrays.copyOf(this.clientLibCategoriesJsBody, this.clientLibCategoriesJsBody.length);
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsHead() {
        return Arrays.copyOf(this.clientLibCategoriesJsHead, this.clientLibCategoriesJsHead.length);
    }

    @Override
    public String getAppResourcesPath() {
        return this.appResourcesPath;
    }

    @Override
    public String getCssClassNames() {
        Set cssClassesSet = this.componentContext.getCssClassNames();
        return StringUtils.join((Iterable)cssClassesSet, (String)" ");
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        return super.getExportedItemsOrder();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return super.getExportedItems();
    }

    @Override
    @Nullable
    public NavigationItem getRedirectTarget() {
        return this.redirectTarget;
    }

    @Override
    public boolean hasCloudconfigSupport() {
        if (this.hasCloudconfigSupport == null) {
            this.hasCloudconfigSupport = this.productInfoProvider == null || this.productInfoProvider.getProductInfo() == null || this.productInfoProvider.getProductInfo().getVersion() == null ? Boolean.valueOf(false) : Boolean.valueOf(this.productInfoProvider.getProductInfo().getVersion().compareTo(new Version("6.4.0")) >= 0);
        }
        return this.hasCloudconfigSupport;
    }
}

