/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.form.FormConstants;
import com.day.cq.wcm.foundation.forms.FormStructureHelperFactory;
import com.day.cq.wcm.foundation.forms.FormsHandlingServletHelper;
import com.day.cq.wcm.foundation.security.SaferSlingPostValidator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class, Filter.class}, configurationPid={"com.adobe.cq.wcm.core.components.commons.forms.impl.CoreFormsHandlingServlet"}, property={"sling.servlet.resourceTypes=core/wcm/components/form/container/v1/container", "sling.servlet.resourceTypes=core/wcm/components/form/container/v2/container", "sling.servlet.methods=POST", "sling.servlet.selectors=form", "sling.servlet.extensions=html", "sling.filter.scope=request", "service.ranking:Integer=610"})
@Designate(ocd=Configuration.class)
public class CoreFormHandlingServlet
extends SlingAllMethodsServlet
implements Filter {
    static final String SELECTOR = "form";
    static final String EXTENSION = "html";
    private static final Boolean PROP_ALLOW_EXPRESSION_DEFAULT = true;
    private String[] dataNameWhitelist;
    private FormsHandlingServletHelper formsHandlingServletHelper;
    private boolean allowExpressions;
    @Reference
    private SaferSlingPostValidator validator;
    @Reference
    private FormStructureHelperFactory formStructureHelperFactory;

    @Activate
    protected void activate(Configuration configuration) {
        this.dataNameWhitelist = PropertiesUtil.toStringArray((Object)configuration.name_whitelist());
        this.allowExpressions = PropertiesUtil.toBoolean((Object)configuration.allow_expressions(), (boolean)PROP_ALLOW_EXPRESSION_DEFAULT);
        this.formsHandlingServletHelper = new FormsHandlingServletHelper(this.dataNameWhitelist, this.validator, FormConstants.RT_ALL_CORE_FORM_CONTAINER, this.allowExpressions, this.formStructureHelperFactory);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.formsHandlingServletHelper.doPost(request, response);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.formsHandlingServletHelper.handleFilter(request, response, chain, EXTENSION, SELECTOR);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    @ObjectClassDefinition(name="Core Form Handling Servlet", description="Accepts posting to a form container component and performs validations")
    static @interface Configuration {
        @AttributeDefinition(name="Parameter Name Whitelist", description="List of name expressions that will pass request validation. A validation error will occur if any posted parameters are not in the whitelist and not defined on the form.")
        public String[] name_whitelist() default {};

        @AttributeDefinition(name="Allow Expressoins", description="Evaluate expressions on form submissions.")
        public boolean allow_expressions() default true;
    }
}

