/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.granite.ui.components.ExpressionCustomizer;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@org.osgi.service.component.annotations.Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/renderconditions/imagedelegate", "sling.servlet.methods=GET"})
public class ImageDelegateRenderCondition
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE = "core/wcm/components/renderconditions/imagedelegate";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String imageDelegate;
        String resourceType;
        Component component;
        Resource policiesRootPage;
        boolean hasImageDelegation = false;
        ResourceResolver resourceResolver = request.getResourceResolver();
        ComponentManager componentManager = (ComponentManager)resourceResolver.adaptTo(ComponentManager.class);
        String suffix = request.getRequestPathInfo().getSuffix();
        if (componentManager != null && StringUtils.isNotEmpty((CharSequence)suffix) && (policiesRootPage = this.getPoliciesRootPage(resourceResolver, suffix)) != null && (component = componentManager.getComponent(resourceType = suffix.substring(policiesRootPage.getPath().length() + 1, suffix.lastIndexOf(47)))) != null && component.isAccessible() && StringUtils.isNotEmpty((CharSequence)(imageDelegate = (String)component.getProperties().get("imageDelegate", String.class)))) {
            hasImageDelegation = true;
            Component delegate = componentManager.getComponent(imageDelegate);
            if (delegate != null && delegate.isAccessible()) {
                ExpressionCustomizer customizer = ExpressionCustomizer.from((ServletRequest)request);
                customizer.setVariable("imageDelegate", (Object)delegate);
            }
        }
        request.setAttribute(RenderCondition.class.getName(), (Object)new SimpleRenderCondition(hasImageDelegation));
    }

    @Nullable
    private Resource getPoliciesRootPage(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        Resource resource = resourceResolver.getResource(path);
        if (resource != null && resource.getResourceType().equals("cq:Page")) {
            return resource;
        }
        if (StringUtils.isNotEmpty((CharSequence)path) && path.lastIndexOf(47) > 0) {
            return this.getPoliciesRootPage(resourceResolver, path.substring(0, path.lastIndexOf(47)));
        }
        return null;
    }
}

