/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.HashMap;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String PN_COMPONENT_PATH = "componentPath";

    @NotNull
    protected abstract ExpressionResolver getExpressionResolver();

    Config getConfig(SlingHttpServletRequest request) {
        Resource datasource = request.getResource().getChild(Config.DATASOURCE);
        if (datasource == null) {
            return null;
        }
        return new Config(datasource);
    }

    ValueMap getComponentValueMap(Config config, SlingHttpServletRequest request) {
        if (config == null) {
            return null;
        }
        String componentPath = this.getParameter(config, PN_COMPONENT_PATH, request);
        if (componentPath == null) {
            return null;
        }
        Resource component = request.getResourceResolver().getResource(componentPath);
        if (component == null) {
            return null;
        }
        return component.getValueMap();
    }

    @Nullable
    protected String getParameter(@NotNull Config config, @NotNull String name, @NotNull SlingHttpServletRequest request) {
        String value = (String)config.get(name, String.class);
        if (value == null) {
            return null;
        }
        ExpressionHelper expressionHelper = new ExpressionHelper(this.getExpressionResolver(), request);
        return expressionHelper.getString(value);
    }

    @NotNull
    protected Resource createResource(@NotNull ResourceResolver resolver, @NotNull String textValue, @NotNull String valueValue) {
        ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
        properties.put((Object)"text", (Object)textValue);
        properties.put((Object)"value", (Object)valueValue);
        return new ValueMapResource(resolver, new ResourceMetadata(), "sling:nonexisting", (ValueMap)properties);
    }
}

