/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.cq.wcm.core.components.internal.servlets.contentfragment.AbstractDataSourceServlet;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v1/datasource/models", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class ModelDataSourceServlet
extends AbstractDataSourceServlet {
    public static final String RESOURCE_TYPE = "core/wcm/components/contentfragmentlist/v1/datasource/models";
    @Reference
    private ExpressionResolver expressionResolver;

    @Override
    @NotNull
    protected ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        DataSource dataSource = EmptyDataSource.instance();
        ResourceResolver resourceResolver = request.getResourceResolver();
        QueryBuilder queryBuilder = (QueryBuilder)resourceResolver.adaptTo(QueryBuilder.class);
        if (queryBuilder != null) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("path", "/conf");
            parameterMap.put("type", "cq:Template");
            parameterMap.put("p.limit", "-1");
            parameterMap.put("1_property", "jcr:content/model/sling:resourceType");
            parameterMap.put("1_property.value", "wcm/scaffolding/components/scaffolding");
            PredicateGroup predicateGroup = PredicateGroup.create(parameterMap);
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            Query query = queryBuilder.createQuery(predicateGroup, session);
            SearchResult searchResult = query.getResult();
            try (ResourceResolver leakingResourceResolver = null;){
                LinkedList<Resource> resources = new LinkedList<Resource>();
                Iterator resourceIterator = searchResult.getResources();
                while (resourceIterator.hasNext()) {
                    Resource resource = (Resource)resourceIterator.next();
                    if (leakingResourceResolver == null) {
                        leakingResourceResolver = resource.getResourceResolver();
                    }
                    ValueMap modelValueMap = resource.getValueMap();
                    String modelTitle = (String)modelValueMap.get("jcr:content/jcr:title", (Object)resource.getName());
                    String modelPath = resource.getPath();
                    Resource syntheticResource = this.createResource(resourceResolver, modelTitle, modelPath);
                    resources.add(syntheticResource);
                }
                dataSource = new SimpleDataSource(resources.iterator());
            }
        }
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

