/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.cq.wcm.core.components.internal.servlets.contentfragment.AbstractDataSourceServlet;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v1/datasource/elements", "sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v1/datasource/orderby", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class ModelElementsDataSourceServlet
extends AbstractDataSourceServlet {
    public static final String RESOURCE_TYPE = "core/wcm/components/contentfragmentlist/v1/datasource/elements";
    public static final String RESOURCE_TYPE_ORDER_BY = "core/wcm/components/contentfragmentlist/v1/datasource/orderby";
    protected static final String PARAMETER_AND_PN_MODEL_PATH = "modelPath";
    @Reference
    private ExpressionResolver expressionResolver;

    @Override
    @NotNull
    protected ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        String pathToCFModelElements;
        ResourceResolver resourceResolver;
        Resource cfModelElementRoot;
        Config config;
        ValueMap componentValueMap;
        RequestParameter modelPathRequestParameter = request.getRequestParameter(PARAMETER_AND_PN_MODEL_PATH);
        boolean isOrderBy = request.getResource().isResourceType(RESOURCE_TYPE_ORDER_BY);
        String modelPath = modelPathRequestParameter != null ? modelPathRequestParameter.getString() : ((componentValueMap = this.getComponentValueMap(config = this.getConfig(request), request)) != null ? (String)componentValueMap.get(PARAMETER_AND_PN_MODEL_PATH, String.class) : null);
        DataSource dataSource = EmptyDataSource.instance();
        if (modelPath != null && (cfModelElementRoot = (resourceResolver = request.getResourceResolver()).getResource(pathToCFModelElements = String.format("%s/%s/model/cq:dialog/content/items", modelPath, "jcr:content"))) != null) {
            Iterator resourceIterator = cfModelElementRoot.listChildren();
            LinkedList<Resource> resourceList = new LinkedList<Resource>();
            if (isOrderBy) {
                resourceList.add(this.createResource(resourceResolver, "Created", "jcr:created"));
                resourceList.add(this.createResource(resourceResolver, "Last Modified", "jcr:content/jcr:lastModified"));
            }
            while (resourceIterator.hasNext()) {
                Resource elementResource = (Resource)resourceIterator.next();
                ValueMap valueMap = elementResource.getValueMap();
                String valueValue = (String)valueMap.get("name", (Object)"");
                String textValue = (String)valueMap.get("fieldLabel", (Object)valueValue);
                if (isOrderBy && StringUtils.isNotEmpty((CharSequence)valueValue)) {
                    valueValue = "jcr:content/data/master/" + valueValue;
                }
                String metaType = (String)valueMap.get("metaType", (Object)"");
                if (isOrderBy && !StringUtils.startsWith((CharSequence)metaType, (CharSequence)"text-")) continue;
                Resource syntheticResource = this.createResource(resourceResolver, textValue, valueValue);
                resourceList.add(syntheticResource);
            }
            dataSource = new SimpleDataSource(resourceList.iterator());
        }
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

