/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2018 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
package com.adobe.cq.wcm.core.components.internal.models.v1;

import java.util.List;

import javax.annotation.PostConstruct;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.export.json.ExporterConstants;
import com.adobe.cq.wcm.core.components.models.Carousel;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;

@Model(adaptables = SlingHttpServletRequest.class, adapters = {Carousel.class, ComponentExporter.class, ContainerExporter.class}, resourceType = CarouselImpl.RESOURCE_TYPE)
@Exporter(name = ExporterConstants.SLING_MODEL_EXPORTER_NAME, extensions = ExporterConstants.SLING_MODEL_EXTENSION)
public class CarouselImpl extends PanelContainerImpl implements Carousel {

    public static final String RESOURCE_TYPE = "core/wcm/components/carousel/v1/carousel";
    protected static final Long DEFAULT_DELAY = 5000L; // milliseconds

    @ScriptVariable
    protected ValueMap properties;

    @ValueMapValue(injectionStrategy = InjectionStrategy.OPTIONAL)
    protected String accessibilityLabel;

    protected boolean autoplay;
    protected Long delay;
    protected boolean autopauseDisabled;

    @PostConstruct
    protected void initModel() {
        autoplay = properties.get(PN_AUTOPLAY, currentStyle.get(PN_AUTOPLAY, false));
        delay = properties.get(PN_DELAY, currentStyle.get(PN_DELAY, DEFAULT_DELAY));
        autopauseDisabled = properties.get(PN_AUTOPAUSE_DISABLED, currentStyle.get(PN_AUTOPAUSE_DISABLED, false));
    }

    @Override
    public boolean getAutoplay() {
        return autoplay;
    }

    @Override
    public Long getDelay() {
        return delay;
    }

    @Override
    public boolean getAutopauseDisabled() {
        return autopauseDisabled;
    }

    @Override
    public String getAccessibilityLabel() {
        return accessibilityLabel;
    }

    /*
     * DataLayerProvider implementation of field getters
     */

    @Override
    public String[] getDataLayerShownItems() {
        String[] shownItems = new String[0];
        List<ListItem> items = getItems();
        if (!items.isEmpty()) {
            ComponentData componentData = items.get(0).getData();
            if (componentData != null) {
                shownItems = new String[] {componentData.getId()};
            }
        }
        return shownItems;
    }
}
