/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static final String ID_SEPARATOR = "-";

    private Utils() {
    }

    @NotNull
    public static String getURL(@NotNull SlingHttpServletRequest request, @NotNull PageManager pageManager, @NotNull String path) {
        Page page = pageManager.getPage(path);
        if (page != null) {
            return Utils.getURL(request, page);
        }
        return path;
    }

    @NotNull
    public static String getURL(@NotNull SlingHttpServletRequest request, @NotNull Page page) {
        String vanityURL = page.getVanityUrl();
        return StringUtils.isEmpty((CharSequence)vanityURL) ? request.getContextPath() + page.getPath() + ".html" : request.getContextPath() + vanityURL;
    }

    public static String generateId(String prefix, String path) {
        return StringUtils.join((Object[])new String[]{prefix, ID_SEPARATOR, StringUtils.substring((String)DigestUtils.sha256Hex((String)path), (int)0, (int)10)});
    }

    public static enum Heading {
        H1("h1"),
        H2("h2"),
        H3("h3"),
        H4("h4"),
        H5("h5"),
        H6("h6");

        private String element;

        private Heading(String element) {
            this.element = element;
        }

        public static Heading getHeading(String value) {
            for (Heading heading : Heading.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)heading.element, (CharSequence)value)) continue;
                return heading;
            }
            return null;
        }

        public String getElement() {
            return this.element;
        }
    }
}

