/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.DataLayerConfig;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.datalayer.ComponentDataImpl;
import com.adobe.cq.wcm.core.components.models.Component;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentImpl
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponentImpl.class);
    @SlingObject
    protected Resource resource;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected ComponentContext componentContext;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    private String id;
    private Boolean dataLayerEnabled;
    private ComponentData componentData;

    @Override
    @Nullable
    public String getId() {
        if (this.id == null) {
            if (this.resource != null) {
                ValueMap properties = this.resource.getValueMap();
                this.id = (String)properties.get("id", String.class);
            }
            this.id = StringUtils.isEmpty((CharSequence)this.id) ? this.generateId() : StringUtils.replace((String)StringUtils.normalizeSpace((String)StringUtils.trim((String)this.id)), (String)" ", (String)"-");
        }
        return this.id;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    private String generateId() {
        String resourceType = this.resource.getResourceType();
        String prefix = StringUtils.substringAfterLast((String)resourceType, (String)"/");
        String path = this.resource.getPath();
        if (this.currentPage != null && this.componentContext != null) {
            boolean inTemplate;
            PageManager pageManager = this.currentPage.getPageManager();
            Page containingPage = pageManager.getContainingPage(this.resource);
            Template template = this.currentPage.getTemplate();
            boolean inCurrentPage = containingPage != null && StringUtils.equals((CharSequence)containingPage.getPath(), (CharSequence)this.currentPage.getPath());
            boolean bl = inTemplate = template != null && path.startsWith(template.getPath());
            if (!inCurrentPage && !inTemplate) {
                for (ComponentContext parentContext = this.componentContext.getParent(); parentContext != null; parentContext = parentContext.getParent()) {
                    Resource parentContextResource = parentContext.getResource();
                    if (parentContextResource == null) continue;
                    Page parentContextPage = pageManager.getContainingPage(parentContextResource);
                    inCurrentPage = parentContextPage != null && StringUtils.equals((CharSequence)parentContextPage.getPath(), (CharSequence)this.currentPage.getPath());
                    boolean bl2 = inTemplate = template != null && parentContextResource.getPath().startsWith(template.getPath());
                    if (!inCurrentPage && !inTemplate) continue;
                    path = parentContextResource.getPath().concat(this.resource.getPath());
                    break;
                }
            }
        }
        return Utils.generateId(prefix, path);
    }

    private boolean isDataLayerEnabled() {
        if (this.dataLayerEnabled == null) {
            ConfigurationBuilder builder;
            this.dataLayerEnabled = false;
            if (this.resource != null && (builder = (ConfigurationBuilder)this.resource.adaptTo(ConfigurationBuilder.class)) != null) {
                DataLayerConfig dataLayerConfig = (DataLayerConfig)builder.as(DataLayerConfig.class);
                this.dataLayerEnabled = dataLayerConfig.enabled();
            }
        }
        return this.dataLayerEnabled;
    }

    @Override
    @Nullable
    public ComponentData getData() {
        if (!this.isDataLayerEnabled()) {
            return null;
        }
        if (this.componentData == null) {
            this.componentData = this.getComponentData();
        }
        return this.componentData;
    }

    @NotNull
    protected ComponentData getComponentData() {
        return new ComponentDataImpl(this, this.resource);
    }

    @JsonIgnore
    public Resource getDataLayerAssetResource() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerTitle() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerDescription() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerText() {
        return null;
    }

    @JsonIgnore
    public String[] getDataLayerTags() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerUrl() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerLinkUrl() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerTemplatePath() {
        return null;
    }

    @JsonIgnore
    public String getDataLayerLanguage() {
        return null;
    }

    @JsonIgnore
    public String[] getDataLayerShownItems() {
        return null;
    }
}

