/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.internal.resource.ImageResourceWrapper;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageDelegatingModel
extends AbstractComponentImpl {
    public static final String IMAGE_DELEGATE = "imageDelegate";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImageDelegatingModel.class);
    private Component component;
    private Resource toBeWrapped;
    private List<String> hiddenProperties;
    private Resource imageResource;

    protected void setImageResource(@NotNull Component component, @NotNull Resource toBeWrapped, @NotNull List<String> hiddenProperties) {
        this.toBeWrapped = toBeWrapped;
        this.component = component;
        this.hiddenProperties = new ArrayList<String>(hiddenProperties);
    }

    @JsonIgnore
    public Resource getImageResource() {
        if (this.imageResource == null && this.component != null) {
            String delegateResourceType = (String)this.component.getProperties().get(IMAGE_DELEGATE, String.class);
            if (StringUtils.isEmpty((CharSequence)delegateResourceType)) {
                LOGGER.error("In order for image rendering delegation to work correctly you need to set up the imageDelegate property on the {} component; its value has to point to the resource type of an image component.", (Object)this.component.getPath());
            } else {
                this.imageResource = new ImageResourceWrapper(this.toBeWrapped, delegateResourceType, this.hiddenProperties);
            }
        }
        return this.imageResource;
    }
}

