/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.models.Button;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.inject.Named;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Button.class, ComponentExporter.class}, resourceType={"core/wcm/components/button/v1/button"})
@Exporter(name="jackson", extensions={"json"})
public class ButtonImpl
extends AbstractComponentImpl
implements Button {
    public static final String RESOURCE_TYPE = "core/wcm/components/button/v1/button";
    private String linkURL;
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private PageManager pageManager;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="jcr:title")
    private String text;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String link;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String icon;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected String accessibilityLabel;

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getLink() {
        if (this.linkURL == null) {
            Page targetPage = this.pageManager.getPage(this.link);
            this.linkURL = targetPage != null ? Utils.getURL(this.request, targetPage) : this.link;
        }
        return this.linkURL;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getAccessibilityLabel() {
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    public String getDataLayerTitle() {
        return this.getText();
    }

    @Override
    public String getDataLayerLinkUrl() {
        return this.getLink();
    }
}

