/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Download;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Download.class, ComponentExporter.class}, resourceType={"core/wcm/components/download/v1/download"})
@Exporter(name="jackson", extensions={"json"})
public class DownloadImpl
implements Download {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadImpl.class);
    public static final String RESOURCE_TYPE = "core/wcm/components/download/v1/download";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Resource resource;
    @OSGiService
    private MimeTypeService mimeTypeService;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    protected Style currentStyle;
    @SlingObject
    private ResourceResolver resourceResolver;
    private String url;
    private boolean titleFromAsset = false;
    private boolean descriptionFromAsset = false;
    private boolean inline = false;
    private boolean displaySize;
    private boolean displayFormat;
    private boolean displayFilename;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="jcr:title")
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="jcr:description")
    private String description;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String actionText;
    private String titleType;
    private String filename;
    private String format;
    private String size;
    private String extension;
    private long lastModified = 0L;

    @PostConstruct
    protected void initModel() {
        String fileReference = (String)this.properties.get("fileReference", String.class);
        this.titleFromAsset = (Boolean)this.properties.get("titleFromAsset", (Object)this.titleFromAsset);
        this.descriptionFromAsset = (Boolean)this.properties.get("descriptionFromAsset", (Object)this.descriptionFromAsset);
        this.inline = (Boolean)this.properties.get("inline", (Object)this.inline);
        if (this.currentStyle != null) {
            this.titleType = (String)this.currentStyle.get("titleType", String.class);
            this.displaySize = (Boolean)this.currentStyle.get("displaySize", (Object)true);
            this.displayFormat = (Boolean)this.currentStyle.get("displayFormat", (Object)true);
            this.displayFilename = (Boolean)this.currentStyle.get("displayFilename", (Object)true);
        }
        if (StringUtils.isNotBlank((CharSequence)fileReference)) {
            this.initAssetDownload(fileReference);
        } else {
            Resource file = this.resource.getChild("file");
            if (file != null) {
                this.initFileDownload(file);
            }
        }
    }

    private void initFileDownload(Resource file) {
        ValueMap valueMap;
        Resource fileContent;
        this.filename = (String)this.properties.get("fileName", String.class);
        if (StringUtils.isNotEmpty((CharSequence)this.filename) && (fileContent = file.getChild("jcr:content")) != null && (valueMap = (ValueMap)fileContent.adaptTo(ValueMap.class)) != null) {
            Calendar calendar;
            this.format = (String)valueMap.get("jcr:mimeType", String.class);
            if (StringUtils.isNotEmpty((CharSequence)this.format)) {
                this.extension = this.mimeTypeService.getExtension(this.format);
            }
            if ((calendar = (Calendar)valueMap.get("jcr:lastModified", Calendar.class)) != null) {
                this.lastModified = calendar.getTimeInMillis();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.format)) {
                this.extension = this.mimeTypeService.getExtension(this.format);
            }
            this.url = this.getDownloadUrl(file) + "/" + this.filename;
            this.size = FileUtils.byteCountToDisplaySize((long)this.getFileSize(fileContent));
        }
    }

    private void initAssetDownload(String fileReference) {
        Asset downloadAsset;
        Resource downloadResource = this.resourceResolver.getResource(fileReference);
        if (downloadResource != null && (downloadAsset = (Asset)downloadResource.adaptTo(Asset.class)) != null) {
            Object rawFileSizeObject;
            String assetDescription;
            long assetLastModified;
            Calendar resourceLastModified = (Calendar)this.properties.get("jcr:lastModified", Calendar.class);
            if (resourceLastModified != null) {
                this.lastModified = resourceLastModified.getTimeInMillis();
            }
            if ((assetLastModified = downloadAsset.getLastModified()) > this.lastModified) {
                this.lastModified = assetLastModified;
            }
            this.filename = downloadAsset.getName();
            this.format = downloadAsset.getMetadataValue("dc:format");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.format})) {
                this.extension = this.mimeTypeService.getExtension(this.format);
            }
            if (StringUtils.isEmpty((CharSequence)this.extension)) {
                this.extension = FilenameUtils.getExtension((String)this.filename);
            }
            this.url = this.getDownloadUrl(downloadResource);
            if (this.titleFromAsset) {
                this.title = downloadAsset.getMetadataValue("dc:title");
            }
            if (this.descriptionFromAsset && StringUtils.isNotBlank((CharSequence)(assetDescription = downloadAsset.getMetadataValue("dc:description")))) {
                this.description = assetDescription;
            }
            long rawFileSize = (rawFileSizeObject = downloadAsset.getMetadata("dam:size")) != null ? ((Long)rawFileSizeObject).longValue() : downloadAsset.getOriginal().getSize();
            this.size = FileUtils.byteCountToDisplaySize((long)rawFileSize);
        }
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getActionText() {
        return this.actionText;
    }

    @Override
    public String getTitleType() {
        return this.titleType;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public boolean displaySize() {
        return this.displaySize;
    }

    @Override
    public boolean displayFormat() {
        return this.displayFormat;
    }

    @Override
    public boolean displayFilename() {
        return this.displayFilename;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    private long getFileSize(Resource resource) {
        long size = 0L;
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                Property data = node.getProperty("jcr:data");
                size = data.getBinary().getSize();
            }
            catch (RepositoryException ex) {
                LOGGER.error("Unable to detect binary file size for " + resource.getPath(), (Throwable)ex);
            }
        }
        return size;
    }

    @NotNull
    private String getDownloadUrl(Resource resource) {
        StringBuilder downloadUrlBuilder = new StringBuilder();
        downloadUrlBuilder.append(resource.getPath()).append(".").append("coredownload").append(".");
        if (this.inline) {
            downloadUrlBuilder.append("inline").append(".");
        }
        downloadUrlBuilder.append(this.extension);
        return downloadUrlBuilder.toString();
    }
}

