/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.ExperienceFragment;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveCopy;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.text.Text;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RangeIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ExperienceFragment.class, ComponentExporter.class}, resourceType={"core/wcm/components/experiencefragment/v1/experiencefragment"})
@Exporter(name="jackson", extensions={"json"})
public class ExperienceFragmentImpl
implements ExperienceFragment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperienceFragmentImpl.class);
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/experiencefragment/v1/experiencefragment";
    private static final String PATH_DELIMITER = "/";
    private static final char PATH_DELIMITER_CHAR = '/';
    private static final String CONTENT_ROOT = "/content";
    private static final String EXPERIENCE_FRAGMENTS_ROOT = "/content/experience-fragments";
    private static final String JCR_CONTENT_ROOT = "/jcr:content";
    @Self
    private SlingHttpServletRequest request;
    @Inject
    protected Resource resource;
    @SlingObject
    private ResourceResolver resolver;
    @ScriptVariable
    private Page currentPage;
    @ValueMapValue(name="fragmentVariationPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String fragmentVariationPath;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    private String localizedFragmentVariationPath;
    private String name;

    @PostConstruct
    protected void initModel() {
        Page xfPage;
        Page xfVariationPage;
        PageManager pageManager;
        if (this.inTemplate()) {
            String currentPageRootPath = this.getLocalizationRoot(this.currentPage.getPath());
            String xfRootPath = this.getXfLocalizationRoot(this.fragmentVariationPath, currentPageRootPath);
            if (!StringUtils.isEmpty((CharSequence)currentPageRootPath) && !StringUtils.isEmpty((CharSequence)xfRootPath)) {
                String xfRelativePath = StringUtils.substring((String)this.fragmentVariationPath, (int)xfRootPath.length());
                String localizedXfRootPath = StringUtils.replace((String)currentPageRootPath, (String)CONTENT_ROOT, (String)EXPERIENCE_FRAGMENTS_ROOT, (int)1);
                this.localizedFragmentVariationPath = StringUtils.join((Object[])new String[]{localizedXfRootPath, xfRelativePath, JCR_CONTENT_ROOT});
            }
        }
        if ((pageManager = (PageManager)this.resolver.adaptTo(PageManager.class)) != null && (xfVariationPage = pageManager.getPage(this.fragmentVariationPath)) != null && (xfPage = xfVariationPage.getParent()) != null) {
            this.name = xfPage.getName();
        }
        String xfContentPath = StringUtils.join((Object[])new String[]{this.fragmentVariationPath, JCR_CONTENT_ROOT});
        if (!this.resourceExists(this.localizedFragmentVariationPath) && this.resourceExists(xfContentPath)) {
            this.localizedFragmentVariationPath = xfContentPath;
        }
        if (!this.isExperienceFragmentVariation(this.localizedFragmentVariationPath)) {
            this.localizedFragmentVariationPath = null;
        }
    }

    @Override
    public String getLocalizedFragmentVariationPath() {
        return this.localizedFragmentVariationPath;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    private String getLocalizationRoot(String path) {
        String root = null;
        if (!StringUtils.isEmpty((CharSequence)path)) {
            Resource resource = this.resolver.getResource(path);
            root = this.getLanguageRoot(resource);
            if (StringUtils.isEmpty((CharSequence)root)) {
                root = this.getBlueprintPath(resource);
            }
            if (StringUtils.isEmpty((CharSequence)root)) {
                root = this.getLiveCopyPath(resource);
            }
        }
        return root;
    }

    private String getLanguageRoot(Resource resource) {
        Page rootPage = this.languageManager.getLanguageRoot(resource);
        if (rootPage != null) {
            return rootPage.getPath();
        }
        return null;
    }

    private String getBlueprintPath(Resource resource) {
        try {
            if (this.relationshipManager.isSource(resource)) {
                LiveRelationship relationship;
                LiveCopy liveCopy;
                RangeIterator liveCopiesIterator = null;
                liveCopiesIterator = this.relationshipManager.getLiveRelationships(resource, null, null);
                if (liveCopiesIterator != null && (liveCopy = (relationship = (LiveRelationship)liveCopiesIterator.next()).getLiveCopy()) != null) {
                    return liveCopy.getBlueprintPath();
                }
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the blueprint: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String getLiveCopyPath(Resource resource) {
        try {
            LiveCopy liveCopy;
            LiveRelationship liveRelationship;
            if (this.relationshipManager.hasLiveRelationship(resource) && (liveRelationship = this.relationshipManager.getLiveRelationship(resource, false)) != null && (liveCopy = liveRelationship.getLiveCopy()) != null) {
                return liveCopy.getPath();
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the live copy: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String getXfLocalizationRoot(String xfPath, String currentPageRoot) {
        String[] referenceRootTokens;
        int xfRootDepth;
        String[] xfPathTokens;
        String xfRoot = null;
        if (!StringUtils.isEmpty((CharSequence)xfPath) && !StringUtils.isEmpty((CharSequence)currentPageRoot) && this.resolver.getResource(xfPath) != null && this.resolver.getResource(currentPageRoot) != null && (xfPathTokens = Text.explode((String)xfPath, (int)47)).length >= (xfRootDepth = (referenceRootTokens = Text.explode((String)currentPageRoot, (int)47)).length + 1)) {
            String[] xfRootTokens = new String[xfRootDepth];
            System.arraycopy(xfPathTokens, 0, xfRootTokens, 0, xfRootDepth);
            xfRoot = StringUtils.join((Object[])new String[]{PATH_DELIMITER, Text.implode((String[])xfRootTokens, (String)PATH_DELIMITER)});
        }
        return xfRoot;
    }

    private boolean resourceExists(String path) {
        return StringUtils.isNotEmpty((CharSequence)path) && this.resolver.getResource(path) != null;
    }

    private boolean inTemplate() {
        Template template = this.currentPage.getTemplate();
        return template != null && StringUtils.startsWith((CharSequence)this.resource.getPath(), (CharSequence)template.getPath());
    }

    private boolean isExperienceFragmentVariation(String path) {
        Resource resource;
        if (StringUtils.isNotEmpty((CharSequence)path) && (resource = this.resolver.getResource(path)) != null) {
            ValueMap properties = resource.getValueMap();
            String xfVariantType = (String)properties.get("cq:xfVariantType", String.class);
            return xfVariantType != null;
        }
        return false;
    }
}

