/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.day.cq.commons.RangeIterator;
import com.day.cq.search.Predicate;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={com.adobe.cq.wcm.core.components.models.List.class, ComponentExporter.class}, resourceType={"core/wcm/components/list/v1/list"})
@Exporter(name="jackson", extensions={"json"})
public class ListImpl
extends AbstractComponentImpl
implements com.adobe.cq.wcm.core.components.models.List {
    protected static final String RESOURCE_TYPE = "core/wcm/components/list/v1/list";
    private static final Logger LOGGER = LoggerFactory.getLogger(ListImpl.class);
    private static final int LIMIT_DEFAULT = 100;
    private static final boolean SHOW_DESCRIPTION_DEFAULT = false;
    private static final boolean SHOW_MODIFICATION_DATE_DEFAULT = false;
    private static final boolean LINK_ITEMS_DEFAULT = false;
    private static final int PN_DEPTH_DEFAULT = 1;
    private static final String PN_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    private static final String TAGS_MATCH_ANY_VALUE = "any";
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @ScriptVariable
    private Page currentPage;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private SlingHttpServletRequest request;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={100})
    private int limit;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={1})
    private int childDepth;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String query;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={0})
    private int maxItems;
    private String startIn;
    private SortOrder sortOrder;
    private OrderBy orderBy;
    private String dateFormatString;
    private boolean showDescription;
    private boolean showModificationDate;
    private boolean linkItems;
    private PageManager pageManager;
    protected List<Page> listItems;

    @PostConstruct
    private void initModel() {
        this.pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
        this.readProperties();
    }

    private void readProperties() {
        this.startIn = (String)this.properties.get("searchIn", (Object)this.currentPage.getPath());
        this.sortOrder = SortOrder.fromString((String)this.properties.get("sortOrder", (Object)SortOrder.ASC.value));
        this.orderBy = OrderBy.fromString((String)this.properties.get("orderBy", (Object)""));
        this.showDescription = (Boolean)this.properties.get("showDescription", this.currentStyle.get("showDescription", (Object)false));
        this.showModificationDate = (Boolean)this.properties.get("showModificationDate", this.currentStyle.get("showModificationDate", (Object)false));
        this.linkItems = (Boolean)this.properties.get("linkItems", this.currentStyle.get("linkItems", (Object)false));
        this.dateFormatString = (String)this.properties.get("dateFormat", this.currentStyle.get("dateFormat", (Object)PN_DATE_FORMAT_DEFAULT));
    }

    @Override
    @Deprecated
    public Collection<Page> getItems() {
        if (this.listItems == null) {
            Source listType = this.getListType();
            this.populateListItems(listType);
        }
        return this.listItems;
    }

    @Override
    @JsonProperty(value="linkItems")
    public boolean linkItems() {
        return this.linkItems;
    }

    @Override
    @JsonProperty(value="showDescription")
    public boolean showDescription() {
        return this.showDescription;
    }

    @Override
    @JsonProperty(value="showModificationDate")
    public boolean showModificationDate() {
        return this.showModificationDate;
    }

    @Override
    public String getDateFormatString() {
        return this.dateFormatString;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    protected Source getListType() {
        String listFromValue = (String)this.properties.get("listFrom", this.currentStyle.get("listFrom", (Object)""));
        return Source.fromString(listFromValue);
    }

    protected void populateListItems(Source listType) {
        switch (listType) {
            case STATIC: {
                this.populateStaticListItems();
                break;
            }
            case CHILDREN: {
                this.populateChildListItems();
                break;
            }
            case TAGS: {
                this.populateTagListItems();
                break;
            }
            case SEARCH: {
                this.populateSearchListItems();
                break;
            }
            default: {
                this.listItems = new ArrayList<Page>();
            }
        }
        this.sortListItems();
        this.setMaxItems();
    }

    private void populateStaticListItems() {
        String[] pagesPaths;
        this.listItems = new ArrayList<Page>();
        for (String path : pagesPaths = (String[])this.properties.get("pages", (Object)new String[0])) {
            Page page = this.pageManager.getContainingPage(path);
            if (page == null) continue;
            this.listItems.add(page);
        }
    }

    private void populateChildListItems() {
        this.listItems = new ArrayList<Page>();
        Page rootPage = this.getRootPage("parentPage");
        if (rootPage != null) {
            this.collectChildren(rootPage.getDepth(), rootPage);
        }
    }

    private void collectChildren(int startLevel, Page parent) {
        Iterator childIterator = parent.listChildren();
        while (childIterator.hasNext()) {
            Page child = (Page)childIterator.next();
            this.listItems.add(child);
            if (child.getDepth() - startLevel >= this.childDepth) continue;
            this.collectChildren(startLevel, child);
        }
    }

    private void populateTagListItems() {
        RangeIterator resourceRangeIterator;
        TagManager tagManager;
        Page rootPage;
        this.listItems = new ArrayList<Page>();
        Object[] tags = (String[])this.properties.get("tags", (Object)new String[0]);
        boolean matchAny = ((String)this.properties.get("tagsMatch", (Object)TAGS_MATCH_ANY_VALUE)).equals(TAGS_MATCH_ANY_VALUE);
        if (ArrayUtils.isNotEmpty((Object[])tags) && (rootPage = this.getRootPage("tagsSearchRoot")) != null && (tagManager = (TagManager)this.resourceResolver.adaptTo(TagManager.class)) != null && (resourceRangeIterator = tagManager.find(rootPage.getPath(), (String[])tags, matchAny)) != null) {
            while (resourceRangeIterator.hasNext()) {
                Page containingPage = this.pageManager.getContainingPage((Resource)resourceRangeIterator.next());
                if (containingPage == null) continue;
                this.listItems.add(containingPage);
            }
        }
    }

    private void populateSearchListItems() {
        SimpleSearch search;
        this.listItems = new ArrayList<Page>();
        if (!StringUtils.isBlank((CharSequence)this.query) && (search = (SimpleSearch)this.resource.adaptTo(SimpleSearch.class)) != null) {
            search.setQuery(this.query);
            search.setSearchIn(this.startIn);
            search.addPredicate(new Predicate("type", "type").set("type", "cq:Page"));
            search.setHitsPerPage((long)this.limit);
            try {
                this.collectSearchResults(search.getResult());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve search results for query.", (Throwable)e);
            }
        }
    }

    private void collectSearchResults(SearchResult result) throws RepositoryException {
        for (Hit hit : result.getHits()) {
            Page containingPage = this.pageManager.getContainingPage(hit.getResource());
            if (containingPage == null) continue;
            this.listItems.add(containingPage);
        }
    }

    private void sortListItems() {
        if (this.orderBy != null) {
            this.listItems.sort(new ListSort(this.orderBy, this.sortOrder));
        }
    }

    private void setMaxItems() {
        if (this.maxItems != 0) {
            ArrayList<Page> tmpListItems = new ArrayList<Page>();
            for (Page item : this.listItems) {
                if (tmpListItems.size() >= this.maxItems) break;
                tmpListItems.add(item);
            }
            this.listItems = tmpListItems;
        }
    }

    private Page getRootPage(String fieldName) {
        String parentPath = (String)this.properties.get(fieldName, (Object)this.currentPage.getPath());
        if (StringUtils.isBlank((CharSequence)parentPath)) {
            parentPath = this.currentPage.getPath();
        }
        return this.pageManager.getContainingPage(this.resourceResolver.getResource(parentPath));
    }

    private static class ListSort
    implements Comparator<Page>,
    Serializable {
        private static final long serialVersionUID = 204096578105548876L;
        private SortOrder sortOrder;
        private OrderBy orderBy;

        ListSort(OrderBy orderBy, SortOrder sortOrder) {
            this.orderBy = orderBy;
            this.sortOrder = sortOrder;
        }

        @Override
        public int compare(Page item1, Page item2) {
            int i = 0;
            if (this.orderBy == OrderBy.MODIFIED) {
                i = ObjectUtils.compare((Comparable)item1.getLastModified(), (Comparable)item2.getLastModified(), (boolean)true);
            } else if (this.orderBy == OrderBy.TITLE) {
                i = ObjectUtils.compare((Comparable)((Object)item1.getTitle()), (Comparable)((Object)item2.getTitle()), (boolean)true);
            }
            if (this.sortOrder == SortOrder.DESC) {
                i *= -1;
            }
            return i;
        }
    }

    private static enum OrderBy {
        TITLE("title"),
        MODIFIED("modified");

        private String value;

        private OrderBy(String value) {
            this.value = value;
        }

        public static OrderBy fromString(String value) {
            for (OrderBy s : OrderBy.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }

    private static enum SortOrder {
        ASC("asc"),
        DESC("desc");

        private String value;

        private SortOrder(String value) {
            this.value = value;
        }

        public static SortOrder fromString(String value) {
            for (SortOrder s : SortOrder.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return ASC;
        }
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        SEARCH("search"),
        TAGS("tags"),
        EMPTY("");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

