/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.NavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.Navigation;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.jcr.RangeIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Navigation.class, ComponentExporter.class}, resourceType={"core/wcm/components/navigation/v1/navigation"})
@Exporter(name="jackson", extensions={"json"})
public class NavigationImpl
extends AbstractComponentImpl
implements Navigation {
    public static final String RESOURCE_TYPE = "core/wcm/components/navigation/v1/navigation";
    @Self
    private SlingHttpServletRequest request;
    @SlingObject
    private ResourceResolver resourceResolver;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String accessibilityLabel;
    private int structureDepth;
    private String navigationRootPage;
    private List<NavigationItem> items;
    private boolean skipNavigationRoot;
    private boolean isShadowingDisabled;
    private int structureStart;

    @PostConstruct
    private void initModel() {
        this.structureDepth = (Integer)this.properties.get("structureDepth", this.currentStyle.get("structureDepth", (Object)-1));
        boolean collectAllPages = (Boolean)this.properties.get("collectAllPages", this.currentStyle.get("collectAllPages", (Object)true));
        if (collectAllPages) {
            this.structureDepth = -1;
        }
        this.navigationRootPage = (String)this.properties.get("navigationRoot", this.currentStyle.get("navigationRoot", String.class));
        if (this.currentStyle.containsKey((Object)"structureStart") || this.properties.containsKey((Object)"structureStart")) {
            this.structureStart = (Integer)this.properties.get("structureStart", this.currentStyle.get("structureStart", (Object)1));
        } else {
            this.skipNavigationRoot = (Boolean)this.properties.get("skipNavigationRoot", this.currentStyle.get("skipNavigationRoot", (Object)true));
            this.structureStart = this.skipNavigationRoot ? 1 : 0;
        }
        this.isShadowingDisabled = (Boolean)this.properties.get("disableShadowing", this.currentStyle.get("disableShadowing", (Object)false));
    }

    @Override
    public List<NavigationItem> getItems() {
        block4: {
            block5: {
                NavigationRoot navigationRoot;
                block7: {
                    RangeIterator liveCopiesIterator;
                    PageManager pageManager;
                    block6: {
                        if (this.items != null) break block4;
                        pageManager = this.currentPage.getPageManager();
                        Page rootPage = pageManager.getPage(this.navigationRootPage);
                        if (rootPage == null) break block5;
                        navigationRoot = new NavigationRoot(rootPage, this.structureDepth);
                        Page navigationRootLanguageRoot = navigationRoot.getPageResource().map(arg_0 -> ((LanguageManager)this.languageManager).getLanguageRoot(arg_0)).orElse(null);
                        Page currentPageLanguageRoot = this.languageManager.getLanguageRoot(this.currentPage.getContentResource());
                        liveCopiesIterator = null;
                        try {
                            liveCopiesIterator = this.relationshipManager.getLiveRelationships((Resource)navigationRoot.page.adaptTo(Resource.class), null, null);
                        }
                        catch (WCMException wCMException) {
                            // empty catch block
                        }
                        if (navigationRootLanguageRoot == null || currentPageLanguageRoot == null || navigationRootLanguageRoot.equals(currentPageLanguageRoot)) break block6;
                        Page languageCopyNavigationRoot = pageManager.getPage(ResourceUtil.normalize((String)(currentPageLanguageRoot.getPath() + "/" + this.getRelativePath(navigationRootLanguageRoot, navigationRoot.page))));
                        if (languageCopyNavigationRoot == null) break block7;
                        navigationRoot = new NavigationRoot(languageCopyNavigationRoot, this.structureDepth);
                        break block7;
                    }
                    if (liveCopiesIterator != null) {
                        while (liveCopiesIterator.hasNext()) {
                            Page liveCopyNavigationRoot;
                            LiveRelationship relationship = (LiveRelationship)liveCopiesIterator.next();
                            String currentPagePath = this.currentPage.getPath() + "/";
                            if (!currentPagePath.startsWith(relationship.getTargetPath() + "/") || (liveCopyNavigationRoot = pageManager.getPage(relationship.getTargetPath())) == null) continue;
                            navigationRoot = new NavigationRoot(liveCopyNavigationRoot, this.structureDepth);
                            break;
                        }
                    }
                }
                this.items = this.getNavigationTree(navigationRoot);
                break block4;
            }
            this.items = Collections.emptyList();
        }
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public String getAccessibilityLabel() {
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    private List<NavigationItem> getItems(NavigationRoot navigationRoot, Page subtreeRoot) {
        ArrayList<NavigationItem> pages = new ArrayList<NavigationItem>();
        if (navigationRoot.structureDepth == -1 || this.getLevel(subtreeRoot) < navigationRoot.structureDepth) {
            Iterator it = subtreeRoot.listChildren((Filter)new PageFilter());
            while (it.hasNext()) {
                Page page = (Page)it.next();
                int pageLevel = this.getLevel(page);
                int level = pageLevel - navigationRoot.startLevel - 1;
                List<NavigationItem> children = this.getItems(navigationRoot, page);
                boolean isSelected = this.checkSelected(page);
                if (this.structureStart == 0) {
                    ++level;
                }
                pages.add(new NavigationItemImpl(page, isSelected, this.request, level, children, this.getId(), this.isShadowingDisabled));
            }
        }
        return pages;
    }

    private List<NavigationItem> getNavigationTree(NavigationRoot navigationRoot) {
        ArrayList<NavigationItem> itemTree = new ArrayList<NavigationItem>();
        for (NavigationRoot item : this.getRootItems(navigationRoot, this.structureStart)) {
            itemTree.addAll(this.getItems(item, item.page));
        }
        if (this.structureStart == 0) {
            boolean isSelected = this.checkSelected(navigationRoot.page);
            NavigationItemImpl root = new NavigationItemImpl(navigationRoot.page, isSelected, this.request, 0, itemTree, this.getId(), this.isShadowingDisabled);
            itemTree = new ArrayList();
            itemTree.add(root);
        }
        return itemTree;
    }

    private List<NavigationRoot> getRootItems(NavigationRoot navigationRoot, int structureStart) {
        LinkedList<NavigationRoot> pages = new LinkedList<NavigationRoot>();
        pages.addLast(navigationRoot);
        if (structureStart != 0) {
            for (int level = 1; level != structureStart && !pages.isEmpty(); ++level) {
                for (int size = pages.size(); size > 0; --size) {
                    NavigationRoot item = pages.removeFirst();
                    Iterator it = item.page.listChildren((Filter)new PageFilter());
                    while (it.hasNext()) {
                        pages.addLast(new NavigationRoot((Page)it.next(), this.structureDepth));
                    }
                }
            }
        }
        return pages;
    }

    private boolean checkSelected(Page page) {
        return this.currentPage.equals(page) || this.currentPage.getPath().startsWith(page.getPath() + "/") || this.currentPageIsRedirectTarget(page);
    }

    private boolean currentPageIsRedirectTarget(Page page) {
        Page redirectPage;
        PageManager pageManager;
        ValueMap valueMap;
        String redirectTarget;
        boolean currentPageIsRedirectTarget = false;
        Resource contentResource = page.getContentResource();
        if (contentResource != null && StringUtils.isNotBlank((CharSequence)(redirectTarget = (String)(valueMap = contentResource.getValueMap()).get("cq:redirectTarget", String.class))) && (pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class)) != null && this.currentPage.equals(redirectPage = pageManager.getPage(redirectTarget))) {
            currentPageIsRedirectTarget = true;
        }
        return currentPageIsRedirectTarget;
    }

    private int getLevel(Page page) {
        return StringUtils.countMatches((CharSequence)page.getPath(), (CharSequence)"/") - 1;
    }

    @Nullable
    private String getRelativePath(@NotNull Page root, @NotNull Page child) {
        if (child.equals(root)) {
            return ".";
        }
        if ((child.getPath() + "/").startsWith(root.getPath())) {
            return child.getPath().substring(root.getPath().length() + 1);
        }
        return null;
    }

    private class NavigationRoot {
        final Page page;
        int startLevel;
        int structureDepth = -1;

        private NavigationRoot(Page navigationRoot, int configuredStructureDepth) {
            this.page = navigationRoot;
            this.startLevel = NavigationImpl.this.getLevel(navigationRoot);
            if (configuredStructureDepth > -1) {
                this.structureDepth = configuredStructureDepth + this.startLevel;
            }
        }

        @NotNull
        final Optional<Resource> getPageResource() {
            return Optional.ofNullable(Optional.of(this.page).map(Page::getContentResource).map(Resource::getParent).orElseGet(() -> NavigationImpl.this.resourceResolver.getResource(this.page.getPath())));
        }
    }
}

