/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.datalayer.PageDataImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageListItemImpl
extends AbstractListItemImpl
implements ListItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageListItemImpl.class);
    static final String PN_DISABLE_SHADOWING = "disableShadowing";
    public static final boolean PROP_DISABLE_SHADOWING_DEFAULT = false;
    protected SlingHttpServletRequest request;
    protected Page page;

    public PageListItemImpl(@NotNull SlingHttpServletRequest request, @NotNull Page page, String parentId, boolean isShadowingDisabled) {
        super(parentId, page.getContentResource());
        this.request = request;
        this.page = page;
        this.parentId = parentId;
        Page redirectTarget = this.getRedirectTarget(page);
        if (this.shouldSetRedirectTargetAsPage(page, redirectTarget, isShadowingDisabled)) {
            this.page = redirectTarget;
        }
    }

    @Override
    public String getURL() {
        return Utils.getURL(this.request, this.page);
    }

    @Override
    public String getTitle() {
        String title = this.page.getNavigationTitle();
        if (title == null) {
            title = this.page.getPageTitle();
        }
        if (title == null) {
            title = this.page.getTitle();
        }
        if (title == null) {
            title = this.page.getName();
        }
        return title;
    }

    @Override
    public String getDescription() {
        return this.page.getDescription();
    }

    @Override
    public Calendar getLastModified() {
        return this.page.getLastModified();
    }

    @Override
    public String getPath() {
        return this.page.getPath();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.page.getName();
    }

    private boolean shouldSetRedirectTargetAsPage(@NotNull Page page, Page redirectTarget, boolean isShadowingDisabled) {
        return !isShadowingDisabled && redirectTarget != null && !redirectTarget.equals(page);
    }

    private Page getRedirectTarget(@NotNull Page page) {
        String redirectTarget;
        Page result = page;
        PageManager pageManager = page.getPageManager();
        LinkedHashSet<String> redirectCandidates = new LinkedHashSet<String>();
        redirectCandidates.add(page.getPath());
        while (result != null && StringUtils.isNotEmpty((CharSequence)(redirectTarget = (String)result.getProperties().get("cq:redirectTarget", String.class)))) {
            result = pageManager.getPage(redirectTarget);
            if (result == null || redirectCandidates.add(result.getPath())) continue;
            LOGGER.warn("Detected redirect loop for the following pages: {}.", (Object)((Object)redirectCandidates).toString());
            break;
        }
        return result;
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return new PageDataImpl(this, this.resource);
    }

    @Override
    public String getDataLayerTitle() {
        return this.getTitle();
    }

    @Override
    public String getDataLayerLinkUrl() {
        return this.getURL();
    }
}

