/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import java.util.Calendar;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceListItemImpl
extends AbstractListItemImpl
implements ListItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceListItemImpl.class);
    protected String url;
    protected String title;
    protected String description;
    protected Calendar lastModified;
    protected String name;

    public ResourceListItemImpl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, String parentId) {
        super(parentId, resource);
        ValueMap valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        if (valueMap != null) {
            this.title = (String)valueMap.get("jcr:title", String.class);
            this.description = (String)valueMap.get("jcr:description", String.class);
            this.lastModified = (Calendar)valueMap.get("jcr:lastModified", Calendar.class);
        }
        this.path = resource.getPath();
        this.name = resource.getName();
        this.url = null;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Calendar getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDataLayerTitle() {
        return this.getTitle();
    }

    @Override
    public String getDataLayerLinkUrl() {
        return this.getURL();
    }
}

