/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.PanelContainerImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Tabs;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Tabs.class, ComponentExporter.class, ContainerExporter.class}, resourceType={"core/wcm/components/tabs/v1/tabs"})
@Exporter(name="jackson", extensions={"json"})
public class TabsImpl
extends PanelContainerImpl
implements Tabs {
    public static final String RESOURCE_TYPE = "core/wcm/components/tabs/v1/tabs";
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String activeItem;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String accessibilityLabel;
    @SlingObject
    private Resource resource;
    @Self
    SlingHttpServletRequest request;
    private String activeItemName;

    @Override
    public String getActiveItem() {
        if (this.activeItemName == null) {
            Resource active = this.resource.getChild(this.activeItem);
            if (active != null) {
                this.activeItemName = this.activeItem;
            } else {
                ComponentManager componentManager = (ComponentManager)this.request.getResourceResolver().adaptTo(ComponentManager.class);
                if (componentManager != null) {
                    for (Resource res : this.resource.getChildren()) {
                        Component component;
                        if (res == null || (component = componentManager.getComponentOfResource(res)) == null) continue;
                        this.activeItemName = res.getName();
                        break;
                    }
                }
            }
        }
        return this.activeItemName;
    }

    @Override
    public String getAccessibilityLabel() {
        return this.accessibilityLabel;
    }

    @Override
    public String[] getDataLayerShownItems() {
        ComponentData componentData;
        String[] shownItems = new String[]{};
        ListItem activeItem = null;
        String activeItemName = this.getActiveItem();
        List<ListItem> items = this.getItems();
        if (!items.isEmpty() && (componentData = (activeItem = items.stream().filter(e -> StringUtils.equals((CharSequence)e.getName(), (CharSequence)activeItemName)).findFirst().orElse(items.get(0))).getData()) != null) {
            shownItems = new String[]{componentData.getId()};
        }
        return shownItems;
    }
}

