/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractImageDelegatingModel;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Teaser.class, ComponentExporter.class}, resourceType={"core/wcm/components/teaser/v1/teaser"})
@Exporter(name="jackson", extensions={"json"})
public class TeaserImpl
extends AbstractImageDelegatingModel
implements Teaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeaserImpl.class);
    public static final String RESOURCE_TYPE = "core/wcm/components/teaser/v1/teaser";
    private String pretitle;
    private String title;
    private String description;
    private String linkURL;
    private String titleType;
    private boolean actionsEnabled = false;
    private boolean titleHidden = false;
    private boolean descriptionHidden = false;
    private boolean imageLinkHidden = false;
    private boolean pretitleHidden = false;
    private boolean titleLinkHidden = false;
    private boolean titleFromPage = false;
    private boolean descriptionFromPage = false;
    private List<ListItem> actions = new ArrayList<ListItem>();
    private final List<String> hiddenImageResourceProperties = new ArrayList<String>(){
        {
            this.add("jcr:title");
            this.add("jcr:description");
        }
    };
    @ScriptVariable
    private Component component;
    @Inject
    private Resource resource;
    @ScriptVariable
    private PageManager pageManager;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    protected Style currentStyle;
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private ModelFactory modelFactory;
    private Page targetPage;
    private Image image;

    @PostConstruct
    private void initModel() {
        ValueMap properties = this.resource.getValueMap();
        this.actionsEnabled = (Boolean)properties.get("actionsEnabled", (Object)this.actionsEnabled);
        this.populateStyleProperties();
        this.titleFromPage = (Boolean)properties.get("titleFromPage", (Object)this.titleFromPage);
        this.descriptionFromPage = (Boolean)properties.get("descriptionFromPage", (Object)this.descriptionFromPage);
        this.linkURL = (String)properties.get("linkURL", String.class);
        if (this.actionsEnabled) {
            ListItem firstAction;
            this.hiddenImageResourceProperties.add("linkURL");
            this.linkURL = null;
            this.populateActions();
            if (!this.actions.isEmpty() && (firstAction = this.actions.get(0)) != null) {
                this.targetPage = this.pageManager.getPage(firstAction.getPath());
            }
        } else {
            this.targetPage = this.pageManager.getPage(this.linkURL);
        }
        this.pretitle = this.pretitleHidden ? null : (String)properties.get("pretitle", String.class);
        if (this.titleHidden) {
            this.title = null;
        } else {
            this.title = (String)properties.get("jcr:title", String.class);
            if (this.titleFromPage) {
                if (this.targetPage != null) {
                    this.title = (String)StringUtils.defaultIfEmpty((CharSequence)this.targetPage.getPageTitle(), (CharSequence)this.targetPage.getTitle());
                } else if (this.actionsEnabled && !this.actions.isEmpty()) {
                    this.title = this.actions.get(0).getTitle();
                    this.linkURL = this.actions.get(0).getURL();
                } else {
                    this.title = null;
                }
            }
        }
        if (this.descriptionHidden) {
            this.description = null;
        } else {
            this.description = (String)properties.get("jcr:description", String.class);
            if (this.descriptionFromPage) {
                this.description = this.targetPage != null ? this.targetPage.getDescription() : null;
            }
        }
        String fileReference = (String)properties.get("fileReference", String.class);
        boolean hasImage = true;
        if (StringUtils.isEmpty((CharSequence)this.linkURL)) {
            LOGGER.debug("Teaser component from " + this.request.getResource().getPath() + " does not define a link.");
        }
        if (StringUtils.isEmpty((CharSequence)fileReference)) {
            if (this.request.getResource().getChild("file") == null) {
                LOGGER.debug("Teaser component from " + this.request.getResource().getPath() + " does not have an asset or an image file configured.");
                hasImage = false;
            }
        } else if (this.request.getResourceResolver().getResource(fileReference) == null) {
            LOGGER.error("Asset " + fileReference + " configured for the teaser component from " + this.request.getResource().getPath() + " doesn't exist.");
            hasImage = false;
        }
        if (hasImage) {
            this.setImageResource(this.component, this.request.getResource(), this.hiddenImageResourceProperties);
        }
        if (this.targetPage != null) {
            this.linkURL = Utils.getURL(this.request, this.targetPage);
        }
    }

    private void populateStyleProperties() {
        if (this.currentStyle != null) {
            this.pretitleHidden = (Boolean)this.currentStyle.get("pretitleHidden", (Object)this.pretitleHidden);
            this.titleHidden = (Boolean)this.currentStyle.get("titleHidden", (Object)this.titleHidden);
            this.descriptionHidden = (Boolean)this.currentStyle.get("descriptionHidden", (Object)this.descriptionHidden);
            this.titleType = (String)this.currentStyle.get("titleType", (Object)this.titleType);
            this.imageLinkHidden = (Boolean)this.currentStyle.get("imageLinkHidden", (Object)this.imageLinkHidden);
            this.titleLinkHidden = (Boolean)this.currentStyle.get("titleLinkHidden", (Object)this.titleLinkHidden);
            if (this.imageLinkHidden) {
                this.hiddenImageResourceProperties.add("linkURL");
            }
            if (((Boolean)this.currentStyle.get("actionsDisabled", (Object)false)).booleanValue()) {
                this.actionsEnabled = false;
            }
        }
    }

    private void populateActions() {
        Resource actionsNode = this.resource.getChild("actions");
        if (actionsNode != null) {
            for (Resource actionRes : actionsNode.getChildren()) {
                this.actions.add(new Action(actionRes, this.getId()));
            }
        }
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    @Override
    public List<ListItem> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public String getLinkURL() {
        return this.linkURL;
    }

    public String getImagePath() {
        if (this.image != null) {
            return this.image.getSrc();
        }
        final Resource imageResource = this.getImageResource();
        if (imageResource != null) {
            SlingHttpServletRequestWrapper wrappedRequest = new SlingHttpServletRequestWrapper(this.request){

                @NotNull
                public Resource getResource() {
                    return imageResource;
                }
            };
            this.image = (Image)this.modelFactory.getModelFromRequest((SlingHttpServletRequest)wrappedRequest);
            if (this.image != null) {
                return this.image.getSrc();
            }
        }
        return null;
    }

    @Override
    public boolean isImageLinkHidden() {
        return this.imageLinkHidden;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getPretitle() {
        return this.pretitle;
    }

    @Override
    public boolean isTitleLinkHidden() {
        return this.titleLinkHidden;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitleType() {
        Utils.Heading heading = Utils.Heading.getHeading(this.titleType);
        if (heading != null) {
            return heading.getElement();
        }
        return null;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    public String getDataLayerTitle() {
        return this.getTitle();
    }

    @Override
    public String getDataLayerLinkUrl() {
        return this.getLinkURL();
    }

    @Override
    public String getDataLayerDescription() {
        return this.getDescription();
    }

    @JsonIgnoreProperties(value={"path", "description", "lastModified", "name"})
    public class Action
    extends AbstractListItemImpl
    implements ListItem {
        private static final String CTA_ID_PREFIX = "cta";
        private Resource ctaResource;
        private String ctaTitle;
        private String ctaUrl;
        private String ctaPath;
        private Page ctaPage;
        private String ctaParentId;
        private String ctaId;

        private Action(Resource actionRes, String parentId) {
            super(parentId, actionRes);
            this.ctaParentId = parentId;
            this.ctaResource = actionRes;
            ValueMap ctaProperties = actionRes.getValueMap();
            this.ctaTitle = (String)ctaProperties.get("text", String.class);
            this.ctaUrl = (String)ctaProperties.get("link", String.class);
            this.ctaPath = actionRes.getPath();
            if (this.ctaUrl != null && this.ctaUrl.startsWith("/")) {
                this.ctaPage = TeaserImpl.this.pageManager.getPage(this.ctaUrl);
            }
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.ctaTitle;
        }

        @Override
        @Nullable
        public String getPath() {
            return this.ctaUrl;
        }

        @Override
        @Nullable
        public String getURL() {
            if (this.ctaPage != null) {
                return Utils.getURL(TeaserImpl.this.request, this.ctaPage);
            }
            return this.ctaUrl;
        }

        @Override
        @Nullable
        public String getId() {
            if (this.ctaId == null) {
                if (this.ctaResource != null) {
                    ValueMap properties = this.ctaResource.getValueMap();
                    this.ctaId = (String)properties.get("id", String.class);
                }
                if (StringUtils.isEmpty((CharSequence)this.ctaId)) {
                    String prefix = StringUtils.join((Object[])new String[]{this.ctaParentId, "-", CTA_ID_PREFIX});
                    this.ctaId = Utils.generateId(prefix, this.ctaPath);
                } else {
                    this.ctaId = StringUtils.replace((String)StringUtils.normalizeSpace((String)StringUtils.trim((String)this.ctaId)), (String)" ", (String)"-");
                }
            }
            return this.ctaId;
        }

        @Override
        public String getDataLayerLinkUrl() {
            return this.getURL();
        }

        @Override
        public String getDataLayerTitle() {
            return this.getTitle();
        }
    }
}

