/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.models.Title;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Title.class, ComponentExporter.class}, resourceType={"core/wcm/components/title/v1/title", "core/wcm/components/title/v2/title"})
@Exporter(name="jackson", extensions={"json"})
public class TitleImpl
extends AbstractComponentImpl
implements Title {
    protected static final String RESOURCE_TYPE_V1 = "core/wcm/components/title/v1/title";
    protected static final String RESOURCE_TYPE_V2 = "core/wcm/components/title/v2/title";
    private boolean linkDisabled = false;
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Resource resource;
    @ScriptVariable
    private PageManager pageManager;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    private Style currentStyle;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="jcr:title")
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String type;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String linkURL;
    private Utils.Heading heading;

    @PostConstruct
    private void initModel() {
        if (StringUtils.isBlank((CharSequence)this.title)) {
            this.title = (String)StringUtils.defaultIfEmpty((CharSequence)this.currentPage.getPageTitle(), (CharSequence)this.currentPage.getTitle());
        }
        if (this.heading == null) {
            this.heading = Utils.Heading.getHeading(this.type);
            if (this.heading == null && this.currentStyle != null) {
                this.heading = Utils.Heading.getHeading((String)this.currentStyle.get("type", String.class));
            }
        }
        this.linkURL = StringUtils.isNotEmpty((CharSequence)this.linkURL) ? Utils.getURL(this.request, this.pageManager, this.linkURL) : null;
        if (this.currentStyle != null) {
            this.linkDisabled = (Boolean)this.currentStyle.get("linkDisabled", (Object)this.linkDisabled);
        }
    }

    @Override
    public String getText() {
        return this.title;
    }

    @Override
    public String getType() {
        if (this.heading != null) {
            return this.heading.getElement();
        }
        return null;
    }

    @Override
    public String getLinkURL() {
        return this.linkURL;
    }

    @Override
    public boolean isLinkDisabled() {
        return this.linkDisabled;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getDataLayerLinkUrl() {
        return this.getLinkURL();
    }

    @Override
    public String getDataLayerTitle() {
        return this.getText();
    }
}

