/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.contentfragment;

import com.adobe.cq.dam.cfm.converter.ContentTypeConverter;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.contentfragment.DAMContentFragmentImpl;
import com.adobe.cq.wcm.core.components.models.contentfragment.ContentFragmentList;
import com.adobe.cq.wcm.core.components.models.contentfragment.DAMContentFragment;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ContentFragmentList.class, ComponentExporter.class}, resourceType={"core/wcm/components/contentfragmentlist/v1/contentfragmentlist"})
@Exporter(name="jackson", extensions={"json"})
public class ContentFragmentListImpl
implements ContentFragmentList {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFragmentListImpl.class);
    public static final String RESOURCE_TYPE = "core/wcm/components/contentfragmentlist/v1/contentfragmentlist";
    public static final String DEFAULT_DAM_PARENT_PATH = "/content/dam";
    public static final int DEFAULT_MAX_ITEMS = -1;
    @Self(injectionStrategy=InjectionStrategy.REQUIRED)
    private SlingHttpServletRequest slingHttpServletRequest;
    @Inject
    private ContentTypeConverter contentTypeConverter;
    @SlingObject
    private ResourceResolver resourceResolver;
    @ValueMapValue(name="modelPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String modelPath;
    @ValueMapValue(name="elementNames", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String[] elementNames;
    @ValueMapValue(name="tagNames", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String[] tagNames;
    @ValueMapValue(name="parentPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String parentPath;
    @ValueMapValue(name="maxItems", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={-1})
    private int maxItems;
    @ValueMapValue(name="orderBy", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String orderBy = "jcr:created";
    @ValueMapValue(name="sortOrder", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String sortOrder = "asc";
    private List<DAMContentFragment> items = new ArrayList<DAMContentFragment>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void initModel() {
        if (StringUtils.isEmpty((CharSequence)this.parentPath)) {
            this.parentPath = DEFAULT_DAM_PARENT_PATH;
        }
        if (StringUtils.isEmpty((CharSequence)this.modelPath)) {
            LOG.warn("Please provide a model path");
            return;
        }
        Session session = (Session)this.resourceResolver.adaptTo(Session.class);
        if (session == null) {
            LOG.warn("Session was null therefore no query was executed");
            return;
        }
        QueryBuilder queryBuilder = (QueryBuilder)this.resourceResolver.adaptTo(QueryBuilder.class);
        if (queryBuilder == null) {
            LOG.warn("Query builder was null therefore no query was executed");
            return;
        }
        HashMap<String, String> queryParameterMap = new HashMap<String, String>();
        queryParameterMap.put("path", this.parentPath);
        queryParameterMap.put("type", "dam:Asset");
        queryParameterMap.put("p.limit", Integer.toString(this.maxItems));
        queryParameterMap.put("1_property", "jcr:content/data/cq:model");
        queryParameterMap.put("1_property.value", this.modelPath);
        if (StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
            queryParameterMap.put("orderby", "@" + this.orderBy);
            if (StringUtils.isNotEmpty((CharSequence)this.sortOrder)) {
                queryParameterMap.put("orderby.sort", this.sortOrder);
            }
        }
        ArrayList<String> allTags = new ArrayList<String>();
        if (this.tagNames != null && this.tagNames.length > 0) {
            allTags.addAll(Arrays.asList(this.tagNames));
        }
        if (!allTags.isEmpty()) {
            queryParameterMap.put("2_property", "jcr:content/metadata/jcr:mixinTypes");
            queryParameterMap.put("2_property.value", "cq:Taggable");
            queryParameterMap.put("tagid.property", "jcr:content/metadata/cq:tags");
            for (int i = 0; i < allTags.size(); ++i) {
                queryParameterMap.put(String.format("tagid.%d_value", i + 1), (String)allTags.get(i));
            }
        }
        PredicateGroup predicateGroup = PredicateGroup.create(queryParameterMap);
        Query query = queryBuilder.createQuery(predicateGroup, session);
        SearchResult searchResult = query.getResult();
        LOG.debug("Query statement: '{}'", (Object)searchResult.getQueryStatement());
        try (ResourceResolver leakingResourceResolver = null;){
            Iterator resourceIterator = searchResult.getResources();
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (leakingResourceResolver == null) {
                    leakingResourceResolver = resource.getResourceResolver();
                }
                DAMContentFragmentImpl contentFragmentModel = new DAMContentFragmentImpl(resource, this.contentTypeConverter, null, this.elementNames);
                this.items.add(contentFragmentModel);
            }
        }
    }

    @Override
    @NotNull
    public Collection<DAMContentFragment> getListItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.slingHttpServletRequest.getResource().getResourceType();
    }
}

