/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.datalayer;

import com.adobe.cq.wcm.core.components.models.datalayer.AssetData;
import com.day.cq.dam.api.Asset;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class AssetDataImpl
implements AssetData {
    private final Asset asset;

    public AssetDataImpl(@NotNull Asset asset) {
        this.asset = asset;
    }

    @Override
    public String getId() {
        return this.asset.getID();
    }

    @Override
    public Date getLastModifiedDate() {
        long assetLastModification = this.asset.getLastModified();
        Calendar created = null;
        if (assetLastModification == 0L) {
            ValueMap resourceMap = (ValueMap)this.asset.adaptTo(ValueMap.class);
            if (resourceMap != null) {
                created = (Calendar)resourceMap.get("jcr:created", Calendar.class);
            }
            assetLastModification = null != created ? created.getTimeInMillis() : 0L;
        }
        return new Date(assetLastModification);
    }

    @Override
    public String getFormat() {
        return this.asset.getMimeType();
    }

    @Override
    public String getUrl() {
        return this.asset.getPath();
    }

    @Override
    public String[] getTags() {
        LinkedList<String> assetTags = new LinkedList<String>();
        String tagsValue = this.asset.getMetadataValueFromJcr("cq:tags");
        if (StringUtils.isNotEmpty((CharSequence)tagsValue)) {
            String[] tags;
            for (String tag : tags = tagsValue.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)tag)) continue;
                assetTags.add(tag);
            }
        }
        return assetTags.toArray(new String[assetTags.size()]);
    }
}

