/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.datalayer;

import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDataImpl
implements ComponentData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentDataImpl.class);
    protected final AbstractComponentImpl component;
    protected final Resource resource;

    public ComponentDataImpl(@NotNull AbstractComponentImpl component, @NotNull Resource resource) {
        this.component = component;
        this.resource = resource;
    }

    @Override
    public String getId() {
        return this.component.getId();
    }

    @Override
    public String getParentId() {
        return null;
    }

    @Override
    public String getType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getTitle() {
        return this.component.getDataLayerTitle();
    }

    @Override
    public String getDescription() {
        return this.component.getDataLayerDescription();
    }

    @Override
    public Date getLastModifiedDate() {
        ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
        Calendar lastModified = null;
        if (valueMap != null && (lastModified = (Calendar)valueMap.get("jcr:lastModified", Calendar.class)) == null) {
            lastModified = (Calendar)valueMap.get("jcr:created", Calendar.class);
        }
        if (lastModified != null) {
            return lastModified.getTime();
        }
        return null;
    }

    @Override
    public String getText() {
        return this.component.getDataLayerText();
    }

    @Override
    public String getLinkUrl() {
        return this.component.getDataLayerLinkUrl();
    }

    @Override
    public String getJson() {
        try {
            return String.format("{\"%s\":%s}", this.getId(), new ObjectMapper().writeValueAsString((Object)this));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to generate dataLayer JSON string", (Throwable)e);
            return null;
        }
    }
}

