/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.form;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.form.AbstractFieldImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.form.OptionItemImpl;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Options.class, ComponentExporter.class}, resourceType={"core/wcm/components/form/options/v1/options", "core/wcm/components/form/options/v2/options"})
@Exporter(name="jackson", extensions={"json"})
public class OptionsImpl
extends AbstractFieldImpl
implements Options {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsImpl.class);
    private static final String PN_TYPE = "type";
    private static final String OPTION_ITEMS_PATH = "items";
    private static final String ID_PREFIX = "form-options";
    @ChildResource(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="items")
    private List<Resource> itemResources;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String helpMessage;
    @ValueMapValue(name="type", injectionStrategy=InjectionStrategy.OPTIONAL)
    private String typeString;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String listPath;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String datasourceRT;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="source")
    private String sourceString;
    @ScriptVariable
    private Resource resource;
    @ScriptVariable
    private SlingHttpServletResponse response;
    @ScriptVariable
    private ResourceResolver resolver;
    @Self
    private SlingHttpServletRequest request;
    private Options.Type type;
    private List<OptionItem> optionItems;

    @Override
    public List<OptionItem> getItems() {
        if (this.optionItems == null) {
            this.populateOptionItems();
        }
        return Collections.unmodifiableList(this.optionItems);
    }

    @Override
    public String getHelpMessage() {
        return this.helpMessage;
    }

    @Override
    public Options.Type getType() {
        if (this.type == null) {
            this.type = Options.Type.fromString(this.typeString);
        }
        return this.type;
    }

    @Override
    protected String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getValue() {
        return this.getDefaultValue();
    }

    @Override
    protected String getDefaultName() {
        return null;
    }

    @Override
    protected String getDefaultValue() {
        return null;
    }

    @Override
    protected String getDefaultTitle() {
        return null;
    }

    private void populateOptionItems() {
        this.optionItems = new ArrayList<OptionItem>();
        Source source = Source.getSource(this.sourceString);
        if (source == null) {
            this.populateOptionItemsFromLocal();
        } else {
            switch (source) {
                case DATASOURCE: {
                    this.populateOptionItemsFromDatasource();
                    break;
                }
                case LIST: {
                    this.populateOptionItemsFromList();
                    break;
                }
                default: {
                    this.populateOptionItemsFromLocal();
                }
            }
        }
    }

    private void populateOptionItemsFromLocal() {
        if (this.itemResources != null) {
            for (Resource itemResource : this.itemResources) {
                OptionItemImpl optionItem = new OptionItemImpl(this.request, this.resource, itemResource);
                if (!optionItem.isDisabled() && !StringUtils.isNotBlank((CharSequence)optionItem.getValue())) continue;
                this.optionItems.add(optionItem);
            }
        }
    }

    private void populateOptionItemsFromList() {
        if (StringUtils.isBlank((CharSequence)this.listPath)) {
            return;
        }
        Resource parent = this.resolver.getResource(this.listPath);
        if (parent != null) {
            for (Resource itemResource : parent.getChildren()) {
                OptionItemImpl optionItem = new OptionItemImpl(this.request, this.resource, itemResource);
                if (!optionItem.isDisabled() && !StringUtils.isNotBlank((CharSequence)optionItem.getValue())) continue;
                this.optionItems.add(optionItem);
            }
        }
    }

    private void populateOptionItemsFromDatasource() {
        Iterator itemIterator;
        if (StringUtils.isBlank((CharSequence)this.datasourceRT)) {
            return;
        }
        RequestDispatcherOptions opts = new RequestDispatcherOptions();
        opts.setForceResourceType(this.datasourceRT);
        RequestDispatcher dispatcher = this.request.getRequestDispatcher(this.resource, opts);
        try {
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
            } else {
                LOGGER.error("Failed to include the datasource at " + this.datasourceRT);
            }
        }
        catch (IOException | RuntimeException | ServletException e) {
            LOGGER.error("Failed to include the datasource at " + this.datasourceRT, e);
        }
        SimpleDataSource dataSource = (SimpleDataSource)this.request.getAttribute(DataSource.class.getName());
        if (dataSource != null && (itemIterator = dataSource.iterator()) != null) {
            while (itemIterator.hasNext()) {
                Resource itemResource = (Resource)itemIterator.next();
                OptionItemImpl optionItem = new OptionItemImpl(this.request, this.resource, itemResource);
                if (!optionItem.isDisabled() && !StringUtils.isNotBlank((CharSequence)optionItem.getValue())) continue;
                this.optionItems.add(optionItem);
            }
        }
    }

    private static enum Source {
        LOCAL("local"),
        LIST("list"),
        DATASOURCE("datasource");

        private String element;

        private Source(String element) {
            this.element = element;
        }

        private static Source getSource(String value) {
            for (Source source : Source.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)source.element, (CharSequence)value)) continue;
                return source;
            }
            return null;
        }
    }
}

