/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.ImageAreaImpl;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.day.cq.dam.api.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v2/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.ImageImpl
implements Image {
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v2/image";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    private static final String SRC_URI_TEMPLATE_WIDTH_VAR = "{.width}";
    private static final String CONTENT_POLICY_DELEGATE_PATH = "contentPolicyDelegatePath";
    private String srcUriTemplate;
    private List<ImageArea> areas;
    private boolean uuidDisabled;
    protected String uuid;

    public ImageImpl() {
        this.selector = "coreimg";
    }

    @Override
    @PostConstruct
    protected void initModel() {
        super.initModel();
        boolean altValueFromDAM = (Boolean)this.properties.get("altValueFromDAM", this.currentStyle.get("altValueFromDAM", (Object)true));
        boolean titleValueFromDAM = (Boolean)this.properties.get("titleValueFromDAM", this.currentStyle.get("titleValueFromDAM", (Object)true));
        this.displayPopupTitle = (Boolean)this.properties.get("displayPopupTitle", this.currentStyle.get("displayPopupTitle", (Object)true));
        this.uuidDisabled = (Boolean)this.currentStyle.get("uuidDisabled", (Object)false);
        if (StringUtils.isNotEmpty((CharSequence)this.fileReference)) {
            Resource assetResource = this.request.getResourceResolver().getResource(this.fileReference);
            if (assetResource != null) {
                Asset asset = (Asset)assetResource.adaptTo(Asset.class);
                if (asset != null) {
                    String damTitle;
                    this.uuid = !this.uuidDisabled ? asset.getID() : null;
                    if (!this.isDecorative && altValueFromDAM) {
                        String damDescription = asset.getMetadataValue("dc:description");
                        if (StringUtils.isEmpty((CharSequence)damDescription)) {
                            damDescription = asset.getMetadataValue("dc:title");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)damDescription)) {
                            this.alt = damDescription;
                        }
                    }
                    if (titleValueFromDAM && StringUtils.isNotEmpty((CharSequence)(damTitle = asset.getMetadataValue("dc:title")))) {
                        this.title = damTitle;
                    }
                } else {
                    LOGGER.error("Unable to adapt resource '{}' used by image '{}' to an asset.", (Object)this.fileReference, (Object)this.request.getResource().getPath());
                }
            } else {
                LOGGER.error("Unable to find resource '{}' used by image '{}'.", (Object)this.fileReference, (Object)this.request.getResource().getPath());
            }
        }
        if (this.hasContent) {
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)true);
            String staticSelectors = this.selector;
            if (this.smartSizes.length > 0) {
                staticSelectors = staticSelectors + "." + this.jpegQuality;
            }
            this.srcUriTemplate = this.baseResourcePath + "." + staticSelectors + SRC_URI_TEMPLATE_WIDTH_VAR + "." + this.extension + (this.inTemplate ? this.templateRelativePath : "") + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") + "." + this.extension : "");
            String policyDelegatePath = this.request.getParameter(CONTENT_POLICY_DELEGATE_PATH);
            if (StringUtils.isNotBlank((CharSequence)policyDelegatePath)) {
                this.srcUriTemplate = this.srcUriTemplate + "?contentPolicyDelegatePath=" + policyDelegatePath;
                this.src = this.src + "?contentPolicyDelegatePath=" + policyDelegatePath;
            }
            this.buildJson();
        }
    }

    @Override
    @NotNull
    public int[] getWidths() {
        return Arrays.copyOf(this.smartSizes, this.smartSizes.length);
    }

    @Override
    public String getSrcUriTemplate() {
        return this.srcUriTemplate;
    }

    @Override
    public boolean isLazyEnabled() {
        return !this.disableLazyLoading;
    }

    @Override
    public List<ImageArea> getAreas() {
        if (this.areas == null) {
            String mapProperty;
            this.areas = new ArrayList<ImageArea>();
            if (this.hasContent && StringUtils.isNotEmpty((CharSequence)(mapProperty = (String)this.properties.get("imageMap", String.class)))) {
                String area;
                int coordinatesEndIndex;
                String[] mapAreas;
                String[] stringArray = mapAreas = StringUtils.split((String)mapProperty, (String)"][");
                int n = stringArray.length;
                for (int i = 0; i < n && (coordinatesEndIndex = (area = stringArray[i]).indexOf(41)) >= 0; ++i) {
                    String shapeAndCoords = StringUtils.substring((String)area, (int)0, (int)(coordinatesEndIndex + 1));
                    String shape = StringUtils.substringBefore((String)shapeAndCoords, (String)"(");
                    String coordinates = StringUtils.substringBetween((String)shapeAndCoords, (String)"(", (String)")");
                    String remaining = StringUtils.substring((String)area, (int)(coordinatesEndIndex + 1));
                    String[] remainingTokens = StringUtils.split((String)remaining, (String)"|");
                    if (StringUtils.isBlank((CharSequence)shape) || StringUtils.isBlank((CharSequence)coordinates)) break;
                    if (remainingTokens.length <= 0) continue;
                    String href = StringUtils.removeAll((String)remainingTokens[0], (String)"\"");
                    if (StringUtils.isBlank((CharSequence)href)) break;
                    String target = remainingTokens.length > 1 ? StringUtils.removeAll((String)remainingTokens[1], (String)"\"") : "";
                    String alt = remainingTokens.length > 2 ? StringUtils.removeAll((String)remainingTokens[2], (String)"\"") : "";
                    String relativeCoordinates = remainingTokens.length > 3 ? remainingTokens[3] : "";
                    relativeCoordinates = StringUtils.substringBetween((String)relativeCoordinates, (String)"(", (String)")");
                    if (href.startsWith("/")) {
                        href = Utils.getURL(this.request, this.pageManager, href);
                    }
                    this.areas.add(new ImageAreaImpl(shape, coordinates, relativeCoordinates, href, target, alt));
                }
            }
        }
        return Collections.unmodifiableList(this.areas);
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }
}

