/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Designate(factory=true, ocd=Config.class)
@Component(service={AdaptiveImageServletMappingConfigurationFactory.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class AdaptiveImageServletMappingConfigurationFactory {
    private List<String> resourceTypes;
    private List<String> selectors;
    private List<String> extensions;
    private int defaultResizeWidth;

    @Activate
    @Modified
    void configure(Config config) {
        this.resourceTypes = this.getValues(config.resource_types());
        this.selectors = this.getValues(config.selectors());
        this.extensions = this.getValues(config.extensions());
        this.defaultResizeWidth = config.defaultResizeWidth();
    }

    @NotNull
    public List<String> getResourceTypes() {
        return Collections.unmodifiableList(this.resourceTypes);
    }

    @NotNull
    public List<String> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    @NotNull
    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public int getDefaultResizeWidth() {
        return this.defaultResizeWidth;
    }

    @NotNull
    private List<String> getValues(@NotNull String[] config) {
        ArrayList<String> values = new ArrayList<String>(config.length);
        for (String conf : config) {
            if (!StringUtils.isNotEmpty((CharSequence)conf)) continue;
            values.add(StringUtils.trim((String)conf));
        }
        return values;
    }

    public String toString() {
        return "{resourceTypes: " + this.resourceTypes.toString() + ", selectors: " + this.selectors.toString() + ", extensions: " + this.extensions.toString() + ", defaultResizeWidth: " + this.defaultResizeWidth + "}";
    }

    @ObjectClassDefinition(name="AEM Core WCM Components Adaptive Image Servlet Mapping Configuration", description="Configuration for the adaptive image servlet mapping.")
    static @interface Config {
        @AttributeDefinition(name="Resource types", description="List of resource types for which the adaptive image servlet should be enabled.")
        public String[] resource_types() default {};

        @AttributeDefinition(name="Selectors", description="List of selectors for which the adaptive image servlet should be enabled.")
        public String[] selectors() default {};

        @AttributeDefinition(name="File extensions", description="List of file extensions for which the adaptive image servlet should be enabled.")
        public String[] extensions() default {};

        @AttributeDefinition(name="Default resize width", description="In case the requested image contains no width information in the request and the image also doesn't have a content policy that defines the allowed rendition widths, then the image processed by this server will be resized to this configured width, for images whose width is larger than this value.")
        public int defaultResizeWidth() default 1280;
    }
}

