/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=core/wcm/components/carousel/v1/carousel", "sling.servlet.resourceTypes=core/wcm/components/tabs/v1/tabs", "sling.servlet.resourceTypes=core/wcm/components/accordion/v1/accordion", "sling.servlet.selectors=container", "sling.servlet.extensions=html"})
public class ContainerServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerServlet.class);
    protected static final String SELECTOR = "container";
    protected static final String EXTENSION = "html";
    private static final String PARAM_DELETED_CHILDREN = "delete";
    private static final String PARAM_ORDERED_CHILDREN = "order";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource container = request.getResource();
        try {
            String[] deletedChildrenNames = request.getParameterValues(PARAM_DELETED_CHILDREN);
            if (deletedChildrenNames != null && deletedChildrenNames.length > 0) {
                for (String childName : deletedChildrenNames) {
                    Resource child = container.getChild(childName);
                    if (child == null) continue;
                    resolver.delete(child);
                }
            }
            resolver.commit();
        }
        catch (PersistenceException e) {
            LOGGER.error("Could not delete items of the container at {}", (Object)container.getPath(), (Object)e);
            response.sendError(500);
        }
        try {
            Node containerNode;
            String[] orderedChildrenNames = request.getParameterValues(PARAM_ORDERED_CHILDREN);
            if (orderedChildrenNames != null && orderedChildrenNames.length > 0 && (containerNode = (Node)container.adaptTo(Node.class)) != null) {
                int i;
                for (i = 0; i < orderedChildrenNames.length; ++i) {
                    if (containerNode.hasNode(orderedChildrenNames[i])) continue;
                    containerNode.addNode(orderedChildrenNames[i]);
                }
                for (i = orderedChildrenNames.length - 1; i >= 0; --i) {
                    if (i == orderedChildrenNames.length - 1) {
                        containerNode.orderBefore(orderedChildrenNames[i], null);
                        continue;
                    }
                    containerNode.orderBefore(orderedChildrenNames[i], orderedChildrenNames[i + 1]);
                }
                resolver.commit();
            }
        }
        catch (RepositoryException | PersistenceException e) {
            LOGGER.error("Could not order items of the container at {}", (Object)container.getPath(), (Object)e);
            response.sendError(500);
        }
    }
}

