/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.day.cq.dam.api.Asset;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=dam:Asset", "sling.servlet.resourceTypes=nt:file", "sling.servlet.selectors=coredownload"})
public class DownloadServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DownloadServlet.class);
    public static final String SELECTOR = "coredownload";
    public static final String INLINE_SELECTOR = "inline";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String RFC_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException {
        Asset asset = (Asset)request.getResource().adaptTo(Asset.class);
        if (asset == null) {
            String filename = request.getRequestPathInfo().getSuffix();
            Resource downloadDataResource = request.getResource().getChild("jcr:content");
            if (StringUtils.isNotEmpty((CharSequence)filename) && downloadDataResource != null) {
                this.sendResource(request, response, filename, downloadDataResource);
            }
        } else {
            if (this.isUnchanged(asset.getLastModified(), request)) {
                response.setStatus(304);
                return;
            }
            Optional<Object> inputStream = Optional.empty();
            try {
                inputStream = this.getInputStream(asset);
                if (!inputStream.isPresent()) {
                    response.sendError(404);
                    return;
                }
                response.setStatus(200);
                this.sendResponse((InputStream)inputStream.get(), asset.getOriginal().getSize(), asset.getMimeType(), asset.getName(), asset.getLastModified(), response, this.checkForInlineSelector(request));
            }
            finally {
                if (inputStream.isPresent()) {
                    ((InputStream)inputStream.get()).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResource(SlingHttpServletRequest request, SlingHttpServletResponse response, String filename, Resource downloadDataResource) throws IOException {
        ValueMap valueMap = (ValueMap)downloadDataResource.adaptTo(ValueMap.class);
        if (valueMap != null) {
            Calendar calendar = (Calendar)valueMap.get("jcr:lastModified", Calendar.class);
            if (calendar != null && this.isUnchanged(calendar.getTimeInMillis(), request)) {
                LOG.debug("sending SC_NOT_MODIFIED for {}", (Object)request.getResource().getPath());
                response.setStatus(304);
                return;
            }
            Optional<Object> inputStream = Optional.empty();
            try {
                String mimeType;
                inputStream = this.getInputStream(downloadDataResource);
                if (!inputStream.isPresent()) {
                    response.sendError(404);
                    return;
                }
                long size = this.getResourceSize(downloadDataResource);
                long timestamp = 0L;
                if (calendar != null) {
                    timestamp = calendar.getTimeInMillis();
                }
                if (StringUtils.isNotEmpty((CharSequence)(mimeType = (String)valueMap.get("jcr:mimeType", String.class)))) {
                    this.sendResponse((InputStream)inputStream.get(), size, mimeType, filename, timestamp, response, this.checkForInlineSelector(request));
                    response.setStatus(200);
                } else {
                    response.sendError(404);
                }
            }
            finally {
                if (inputStream.isPresent()) {
                    ((InputStream)inputStream.get()).close();
                }
            }
        }
    }

    private long getResourceSize(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                Binary binary;
                Property jcrData = node.getProperty("jcr:data");
                if (jcrData != null && (binary = jcrData.getBinary()) != null) {
                    return binary.getSize();
                }
            }
            catch (RepositoryException e) {
                LOG.error("Cannot determine size of binary at {}", (Object)resource.getPath(), (Object)e);
            }
        }
        return -1L;
    }

    private boolean checkForInlineSelector(SlingHttpServletRequest request) {
        return Arrays.asList(request.getRequestPathInfo().getSelectors()).contains(INLINE_SELECTOR);
    }

    private Optional<InputStream> getInputStream(Asset asset) {
        return Optional.ofNullable(asset.getOriginal()).map(r -> (InputStream)r.adaptTo(InputStream.class));
    }

    private Optional<InputStream> getInputStream(Resource fileResource) {
        return Optional.ofNullable(fileResource.getValueMap().get("jcr:data", InputStream.class));
    }

    private void sendResponse(InputStream stream, long size, String mimeType, String filename, long lastModifiedDate, SlingHttpServletResponse response, boolean inline) throws IOException {
        response.setContentType(mimeType);
        if (size != -1L) {
            response.setContentLength((int)size);
        }
        if (inline) {
            response.setHeader(CONTENT_DISPOSITION_HEADER, INLINE_SELECTOR);
        } else {
            response.setHeader(CONTENT_DISPOSITION_HEADER, "attachment; filename=\"" + filename + "\"");
        }
        if (lastModifiedDate > 0L) {
            response.setHeader("Last-Modified", this.getLastModifiedDate(lastModifiedDate));
        }
        try (ServletOutputStream outputStream = response.getOutputStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        }
    }

    private String getLastModifiedDate(long lastModifiedDate) {
        SimpleDateFormat df = new SimpleDateFormat(RFC_DATE_FORMAT, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(lastModifiedDate);
    }

    private boolean isUnchanged(long lastModifiedDate, SlingHttpServletRequest request) {
        String headerDate;
        boolean match = false;
        if (Collections.list(request.getHeaderNames()).contains("If-Modified-Since") && StringUtils.isNotEmpty((CharSequence)(headerDate = request.getHeader("If-Modified-Since")))) {
            SimpleDateFormat df = new SimpleDateFormat(RFC_DATE_FORMAT, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                long headerTime = df.parse(headerDate).getTime();
                long assetTime = df.parse(df.format(lastModifiedDate)).getTime();
                if (headerTime >= assetTime) {
                    match = true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return match;
    }
}

