/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.embed;

import com.adobe.cq.wcm.core.components.internal.servlets.TextValueDataResourceSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/embed/v1/datasources/allowedembeddables", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class AllowedEmbeddablesDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/embed/v1/datasources/allowedembeddables";
    private static final long serialVersionUID = -3528015217249498756L;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        SimpleDataSource allowedEmbeddablesDataSource = new SimpleDataSource(this.getAllowedEmbeddables(request).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)allowedEmbeddablesDataSource);
    }

    private List<Resource> getAllowedEmbeddables(@NotNull SlingHttpServletRequest request) {
        ArrayList<Resource> allowedEmbeddableResources = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        Resource contentResource = resolver.getResource((String)request.getAttribute("granite.ui.form.contentpath"));
        ContentPolicyManager policyManager = (ContentPolicyManager)resolver.adaptTo(ContentPolicyManager.class);
        if (policyManager == null || contentResource == null) {
            return allowedEmbeddableResources;
        }
        ValueMap properties = null;
        ContentPolicy policy = policyManager.getPolicy(contentResource);
        if (policy != null) {
            properties = policy.getProperties();
        } else {
            Designer designer = (Designer)resolver.adaptTo(Designer.class);
            if (designer != null) {
                properties = designer.getStyle(contentResource);
            }
        }
        if (properties == null) {
            return allowedEmbeddableResources;
        }
        String[] allowedEmbeddableResourceTypes = (String[])properties.get("allowedEmbeddables", String[].class);
        if (allowedEmbeddableResourceTypes != null && allowedEmbeddableResourceTypes.length > 0) {
            allowedEmbeddableResources.add((Resource)new AllowedEmbeddableResource("Select", "", resolver));
            for (String embeddableResourceType : allowedEmbeddableResourceTypes) {
                Resource componentResource = resolver.getResource(embeddableResourceType);
                if (componentResource == null) continue;
                allowedEmbeddableResources.add((Resource)new AllowedEmbeddableResource((String)componentResource.getValueMap().get("jcr:title", (Object)componentResource.getName()), embeddableResourceType, resolver));
            }
        }
        return allowedEmbeddableResources;
    }

    private static class AllowedEmbeddableResource
    extends TextValueDataResourceSource {
        private final String title;
        private final String resourceType;

        AllowedEmbeddableResource(String embeddableTitle, String embeddableResourceType, ResourceResolver resourceResolver) {
            super(resourceResolver, "", "sling:nonexisting");
            this.title = embeddableTitle;
            this.resourceType = embeddableResourceType;
        }

        @Override
        public String getText() {
            return this.title;
        }

        @Override
        public String getValue() {
            return this.resourceType;
        }
    }
}

