/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.embed;

import com.adobe.cq.wcm.core.components.services.embed.UrlProcessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=core/wcm/components/embed/v1/embed", "sling.servlet.selectors=urlProcessor", "sling.servlet.extensions=json"})
public class EmbedUrlProcessorServlet
extends SlingSafeMethodsServlet {
    protected static final String RESOURCE_TYPE_V1 = "core/wcm/components/embed/v1/embed";
    protected static final String SELECTOR = "urlProcessor";
    protected static final String EXTENSION = "json";
    private static final String PARAM_URL = "url";
    private static final long serialVersionUID = 2187626333327104828L;
    @SuppressFBWarnings(justification="This field needs to be transient")
    private transient List<UrlProcessor> urlProcessors = new ArrayList<UrlProcessor>();

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String url = request.getParameter(PARAM_URL);
        UrlProcessor.Result result = this.getResult(url);
        if (result != null) {
            this.writeJson(result, response);
        } else {
            response.sendError(404);
        }
    }

    private void writeJson(UrlProcessor.Result result, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)response.getWriter(), (Object)result);
    }

    private UrlProcessor.Result getResult(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            for (UrlProcessor urlProcessor : this.urlProcessors) {
                UrlProcessor.Result result = urlProcessor.process(url);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Reference(service=UrlProcessor.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindEmbedUrlProcessor", unbind="unbindEmbedUrlProcessor")
    protected void bindEmbedUrlProcessor(UrlProcessor urlProcessor, Map<?, ?> props) {
        this.urlProcessors.add(urlProcessor);
    }

    protected void unbindEmbedUrlProcessor(UrlProcessor urlProcessor, Map<?, ?> props) {
        this.urlProcessors.remove(urlProcessor);
    }
}

