/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.util.TestUtil;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class VersioningClient
extends CQClient {
    private static final String PAGE_VERSIONS_URL = "/bin/wcm/versions.json";
    private static final String TREE_VERSIONS_URL = "/bin/wcm/versiontree";

    public VersioningClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public VersioningClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public JsonNode getAssetVersions(String assetLocation) throws ClientException, InterruptedException {
        return this.doGetJson(assetLocation + ".version.json", -1, new int[0]).get("versions");
    }

    public SlingHttpResponse createAssetVersion(String assetLocation, String versionLabel, String versionComment, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("cmd", "createVersion");
        formEntry.addParameter("_charset_", "utf-8");
        formEntry.addParameter(":status", "browser");
        formEntry.addParameter("label", versionLabel);
        formEntry.addParameter("comment", versionComment);
        return this.doPost(assetLocation + ".version.html", (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse restoreAssetVersion(String assetLocation, String versionId, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("cmd", "restoreVersion");
        formEntry.addParameter("id", versionId);
        return this.doPost(assetLocation + ".version.html", (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public JsonNode getPageVersions(String pageLocation, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create().add((NameValuePair)new BasicNameValuePair("path", pageLocation));
        SlingHttpResponse exec = this.doGet(PAGE_VERSIONS_URL, params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent()).path("versions");
    }

    public JsonNode getTreeVersions(String path, Date date, boolean preserverNVP, String node, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create();
        params.add((NameValuePair)new BasicNameValuePair("path", path));
        params.add((NameValuePair)new BasicNameValuePair("preserveNVP", Boolean.toString(preserverNVP)));
        params.add((NameValuePair)new BasicNameValuePair("node", node == null ? "." : node));
        if (date != null) {
            params.add((NameValuePair)new BasicNameValuePair("date", TestUtil.ISO_DATETIME_TIME_ZONE_FORMAT.format(date)));
        } else {
            params.add((NameValuePair)new BasicNameValuePair("date", null));
        }
        SlingHttpResponse exec = this.doGet(TREE_VERSIONS_URL, params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getChildrenPageVersions(String parentPageLocation, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create();
        params.add((NameValuePair)new BasicNameValuePair("path", parentPageLocation));
        params.add((NameValuePair)new BasicNameValuePair("showChildren", "true"));
        SlingHttpResponse exec = this.doGet(PAGE_VERSIONS_URL, params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent()).path("versions");
    }

    public long getVersionCreationDate(JsonNode version) throws ParseException {
        String creationDate = version.path("created").getValueAsText();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Date convertDate = dateFormat.parse(creationDate);
        return convertDate.getTime();
    }

    public SlingHttpResponse getPageWithTimeWrap(String pageLocation, long date, int ... expectedStatus) throws ClientException {
        return this.doGet(pageLocation + ".html", null, Collections.singletonList(new BasicHeader("Cookie", "timewarp=" + Long.toString(date))), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

