/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.foundation;

import com.adobe.cq.testing.client.ComponentClient;
import com.adobe.cq.testing.client.components.foundation.AbstractFoundationComponent;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

public class Carousel
extends AbstractFoundationComponent {
    public static final String RESOURCE_TYPE = "foundation/components/carousel";
    public static final String PROP_PLAY_SPEED = "playSpeed";
    public static final String PROP_TRANS_TIME = "transTime";
    public static final String PROP_CONTROLS_TYPE = "controlsType";
    public static final String PROP_LIST_FROM = "listFrom";
    public static final String PROP_ORDER_BY = "orderBy";
    public static final String PROP_LIMIT = "limit";
    public static final String PROP_PARENT_PAGE = "parentPage";
    public static final String PROP_PAGES = "pages";
    public static final String PROP_SEARCH_IN = "searchIn";
    public static final String PROP_QUERY = "query";
    public static final String PROP_SAVED_QUERY = "savedquery";

    public Carousel(ComponentClient client, String pagePath, String location, String nameHint) {
        super(client, pagePath, location, nameHint);
    }

    @Override
    public FormEntityBuilder getCreateFormEntity(String order) {
        return super.getCreateFormEntity(order).addParameter("parentResourceType", "foundation/components/parsys");
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    public SlingHttpResponse edit(int playSpeed, int transTime, String controlsType, String listFrom, String orderBy, int limit, String parentPage, String[] fixedList, String searchIn, String query, String savedQuery, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("_charset_", "utf-8");
        if (playSpeed != 0) {
            form.addParameter("./playSpeed", Integer.toString(playSpeed));
        }
        if (transTime != 0) {
            form.addParameter("./transTime", Integer.toString(transTime));
        }
        if (controlsType != null) {
            form.addParameter("./controlsType", controlsType);
        }
        if (listFrom != null) {
            form.addParameter("./listFrom", listFrom);
        }
        if (orderBy != null) {
            form.addParameter("./orderBy", orderBy);
        }
        if (limit != 0) {
            form.addParameter("./limit", Integer.toString(limit));
        }
        if (parentPage != null) {
            form.addParameter("./parentPage", parentPage);
        }
        if (fixedList != null && fixedList.length > 0) {
            for (String aFixedList : fixedList) {
                form.addParameter("./pages", aFixedList);
            }
        }
        if (searchIn != null) {
            form.addParameter("./searchIn", searchIn);
        }
        if (query != null) {
            form.addParameter("./query", query);
        }
        if (savedQuery != null) {
            form.addParameter("./savedquery", savedQuery);
        }
        return this.client.doPost(this.componentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

