/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.tagging;

import com.adobe.cq.testing.client.TagClient;
import java.util.StringTokenizer;
import org.apache.sling.testing.clients.ClientException;
import org.codehaus.jackson.JsonNode;

public class Tag {
    public static final String PRIMARY_TYPE = "cq:Tag";
    public static final String RESOURCE_TYPE = "cq/tagging/components/tag";
    public static final String TAG_ROOT_PATH = "/content/cq:tags/";
    public static final String TAG_DEFAULT_NAMESPACE_PATH = "/content/cq:tags/default/";
    public static final String TAG_PROP_TITLE = "jcr:title";
    public static final String TAG_PROP_DESCRIPTION = "jcr:description";
    protected String id = "";
    protected String title = null;
    protected String description = null;
    protected String parentTagId = null;
    protected String path = "";
    protected TagClient client = null;
    protected JsonNode jsonNode = null;

    public Tag(TagClient client, String id, String title, String description, String parentTagId) {
        this.client = client;
        this.title = title;
        this.description = description;
        this.id = id;
        try {
            client.createTag(title, id, description, parentTagId, new int[0]);
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        this.parentTagId = parentTagId == null ? id + ":" : parentTagId + this.id + "/";
    }

    public String getParentTagId() {
        return this.parentTagId;
    }

    public String moveTo(Tag tag) throws ClientException {
        String destPath = tag.getPath() + this.id;
        this.client.moveTag(this.getPath(), destPath, new int[0]);
        return destPath;
    }

    public Tag addTag(String id, String title, String description) {
        return new Tag(this.client, id, title, description, this.parentTagId);
    }

    public String getPath() {
        return TAG_ROOT_PATH + this.parentTagId.replace(":", "/");
    }

    public String getNamespacePath() {
        String namespacePath = this.parentTagId;
        if (namespacePath.endsWith("/") || namespacePath.endsWith(":")) {
            namespacePath = namespacePath.substring(0, namespacePath.length() - 1);
        }
        return namespacePath;
    }

    public JsonNode getJsonNode() throws ClientException {
        String path = this.getPath().substring(0, this.getPath().length() - 1);
        this.jsonNode = this.client.doGetJson(path + ".tag", -1, new int[0]);
        return this.jsonNode;
    }

    public JsonNode getJsonNode(String propName) {
        StringTokenizer st = new StringTokenizer(propName, "/");
        JsonNode prop = this.jsonNode;
        while (st.hasMoreElements()) {
            prop = prop.get((String)st.nextElement());
        }
        return prop;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }
}

