/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util.instanceconfig;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQWorkflowClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;

public class WorkflowLauncherInstanceConfig
implements InstanceConfig {
    private final String launcherId;
    private Map<String, String> launcher;
    private CQWorkflowClient wClient;

    public <T extends CQClient> WorkflowLauncherInstanceConfig(T client, String launcherId) throws ClientException {
        this.launcherId = launcherId;
        this.launcher = new HashMap<String, String>();
        this.wClient = (CQWorkflowClient)client.adaptTo(CQWorkflowClient.class);
    }

    public InstanceConfig save() throws InstanceConfigException {
        try {
            this.launcher = this.wClient.getWorkflowLauncher(this.launcherId);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not retrieve workflow launcher info", (Throwable)e);
        }
        return this;
    }

    public InstanceConfig restore() throws InstanceConfigException {
        try {
            this.wClient.editWorkflowLauncher(this.launcherId, this.launcher);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not write workflow launcher info", (Throwable)e);
        }
        return this;
    }
}

