/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util.offloading;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQWorkflowClient;
import com.adobe.cq.testing.client.TopologyClient;
import com.adobe.cq.testing.client.offloading.OffloadingBrowserClient;
import org.apache.sling.testing.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadingSetupUtil {
    public static final Logger LOG = LoggerFactory.getLogger(OffloadingSetupUtil.class);

    public static <T extends CQClient> void setDAMUpdateAssetOffloading(T client) throws ClientException, InterruptedException {
        CQWorkflowClient wClient = (CQWorkflowClient)client.adaptTo(CQWorkflowClient.class);
        wClient.editWorkflowLauncher("update_asset_create", "workflow", "/etc/workflow/models/dam/update_asset_offloading/jcr:content/model");
        wClient.editWorkflowLauncher("update_asset_mod", "workflow", "/etc/workflow/models/dam/update_asset_offloading/jcr:content/model");
    }

    public static <T extends CQClient> void setDAMUpdateAsset(T client) throws ClientException, InterruptedException {
        CQWorkflowClient wClient = (CQWorkflowClient)client.adaptTo(CQWorkflowClient.class);
        wClient.editWorkflowLauncher("update_asset_create", "workflow", "/etc/workflow/models/dam/update_asset/jcr:content/model");
        wClient.editWorkflowLauncher("update_asset_mod", "workflow", "/etc/workflow/models/dam/update_asset/jcr:content/model");
    }

    public static <T extends CQClient> void enableDisableDAMUpdateAsset(T client, boolean enable) throws ClientException, InterruptedException {
        CQWorkflowClient wClient = (CQWorkflowClient)client.adaptTo(CQWorkflowClient.class);
        wClient.enableDisableWorkflowLauncher("update_asset_create", enable);
        wClient.enableDisableWorkflowLauncher("update_asset_mod", enable);
    }

    public static <T extends CQClient> void enableDisableOffloadingTopic(T client, boolean enable) throws ClientException, InterruptedException {
        TopologyClient tClient = (TopologyClient)client.adaptTo(TopologyClient.class);
        OffloadingBrowserClient oClient = (OffloadingBrowserClient)client.adaptTo(OffloadingBrowserClient.class);
        String slingId = tClient.getSlingId();
        oClient.enableDisableTopicWithWait(slingId, "com/adobe/granite/workflow/offloading", enable, 30L);
    }
}

