/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.osxappbundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.mojo.osxappbundle.CopyElement;
import org.codehaus.mojo.osxappbundle.FileSet;
import org.codehaus.mojo.osxappbundle.encoding.DefaultEncodingDetector;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.velocity.VelocityComponent;

public class CreateApplicationBundleMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private MavenProject project;
    private File buildDirectory;
    private File diskImageFile;
    private File javaApplicationStub;
    private String mainClass;
    private String bundleName;
    private File iconFile;
    private String version;
    private String jvmVersion;
    private File zipFile;
    private List additionalClasspath;
    private List additionalResources;
    private List copyElements;
    private Boolean createApplicationSymbolicLink;
    private VelocityComponent velocity;
    private String dictionaryFile;
    private String vmOptions;
    private MavenProjectHelper projectHelper;
    private ZipArchiver zipArchiver;
    private boolean internetEnable;
    private static final String[] SET_FILE_PATH = new String[]{"/Developer/Tools/SetFile", "/usr/bin/SetFile"};

    public void execute() throws MojoExecutionException {
        this.buildDirectory.mkdirs();
        File bundleDir = new File(this.buildDirectory, this.bundleName + ".app");
        bundleDir.mkdirs();
        File contentsDir = new File(bundleDir, "Contents");
        contentsDir.mkdirs();
        File resourcesDir = new File(contentsDir, "Resources");
        resourcesDir.mkdirs();
        File javaDirectory = new File(resourcesDir, "Java");
        javaDirectory.mkdirs();
        File macOSDirectory = new File(contentsDir, "MacOS");
        macOSDirectory.mkdirs();
        File stub = new File(macOSDirectory, this.javaApplicationStub.getName());
        if (!this.javaApplicationStub.exists()) {
            String message = "Can't find JavaApplicationStub binary. File does not exist: " + this.javaApplicationStub;
            if (!this.isOsX()) {
                message = message + "\nNOTICE: You are running the osxappbundle plugin on a non OS X platform. To make this work you need to copy the JavaApplicationStub binary into your source tree. Then configure it with the 'javaApplicationStub' configuration property.\nOn an OS X machine, the JavaApplicationStub is typically located under /System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
            }
            throw new MojoExecutionException(message);
        }
        try {
            FileUtils.copyFile((File)this.javaApplicationStub, (File)stub);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy file " + this.javaApplicationStub + " to directory " + macOSDirectory, (Exception)e);
        }
        if (this.iconFile != null) {
            try {
                FileUtils.copyFileToDirectory((File)this.iconFile, (File)resourcesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + this.iconFile + " to " + resourcesDir, (Exception)e);
            }
        }
        List files = this.copyDependencies(javaDirectory);
        File infoPlist = new File(bundleDir, "Contents/Info.plist");
        this.writeInfoPlist(infoPlist, files);
        if (this.additionalResources != null && !this.additionalResources.isEmpty()) {
            this.copyResources(this.additionalResources);
        }
        if (this.copyElements != null && !this.copyElements.isEmpty()) {
            this.copyElements();
        }
        if (this.createApplicationSymbolicLink != null && this.createApplicationSymbolicLink.equals(Boolean.TRUE) && this.isOsX()) {
            this.createApplicationSymbolicLink();
        }
        if (this.isOsX()) {
            String setFilePath;
            Commandline chmod = new Commandline();
            try {
                chmod.setExecutable("chmod");
                chmod.createArgument().setValue("755");
                chmod.createArgument().setValue(stub.getAbsolutePath());
                chmod.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error executing " + chmod + " ", (Exception)((Object)e));
            }
            String setFileStr = null;
            String[] arr$ = SET_FILE_PATH;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !new File(setFileStr = (setFilePath = arr$[i$])).exists(); ++i$) {
            }
            if (new File(setFileStr).exists()) {
                Commandline setFile = new Commandline();
                try {
                    setFile.setExecutable(setFileStr);
                    setFile.createArgument().setValue("-a B");
                    setFile.createArgument().setValue(bundleDir.getAbsolutePath());
                    setFile.execute();
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("Error executing " + setFile, (Exception)((Object)e));
                }
            } else {
                this.getLog().warn((CharSequence)("Could  not set 'Has Bundle' attribute. " + SET_FILE_PATH + " not found, is Developer Tools installed?"));
            }
            Commandline dmg = new Commandline();
            try {
                dmg.setExecutable("hdiutil");
                dmg.createArgument().setValue("create");
                dmg.createArgument().setValue("-srcfolder");
                dmg.createArgument().setValue(this.buildDirectory.getAbsolutePath());
                dmg.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                try {
                    dmg.execute().waitFor();
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Thread was interrupted while creating DMG " + this.diskImageFile, (Exception)e);
                }
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error creating disk image " + this.diskImageFile, (Exception)((Object)e));
            }
            if (this.internetEnable) {
                try {
                    Commandline internetEnable = new Commandline();
                    internetEnable.setExecutable("hdiutil");
                    internetEnable.createArgument().setValue("internet-enable");
                    internetEnable.createArgument().setValue("-yes");
                    internetEnable.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                    internetEnable.execute();
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("Error internet enabling disk image: " + this.diskImageFile, (Exception)((Object)e));
                }
            }
            this.projectHelper.attachArtifact(this.project, "dmg", null, this.diskImageFile);
        }
        if (this.createApplicationSymbolicLink != null && this.createApplicationSymbolicLink.equals(Boolean.TRUE)) {
            this.removeApplicationLink();
        }
        this.zipArchiver.setDestFile(this.zipFile);
        try {
            String[] stubPattern = new String[]{this.buildDirectory.getName() + "/" + bundleDir.getName() + "/Contents/MacOS/" + this.javaApplicationStub.getName()};
            this.zipArchiver.addDirectory(this.buildDirectory.getParentFile(), new String[]{this.buildDirectory.getName() + "/**"}, stubPattern);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.buildDirectory.getParentFile());
            scanner.setIncludes(stubPattern);
            scanner.scan();
            String[] stubs = scanner.getIncludedFiles();
            for (int i = 0; i < stubs.length; ++i) {
                String s = stubs[i];
                this.zipArchiver.addFile(new File(this.buildDirectory.getParentFile(), s), s, 493);
            }
            this.zipArchiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "zip", null, this.zipFile);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not create zip archive of application bundle in " + this.zipFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException creating zip archive of application bundle in " + this.zipFile, (Exception)e);
        }
    }

    private boolean isOsX() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    }

    private List copyDependencies(File javaDirectory) throws MojoExecutionException {
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        ArrayList<String> list = new ArrayList<String>();
        File repoDirectory = new File(javaDirectory, "repo");
        repoDirectory.mkdirs();
        File artifactFile = this.project.getArtifact().getFile();
        list.add(repoDirectory.getName() + "/" + layout.pathOf(this.project.getArtifact()));
        try {
            FileUtils.copyFile((File)artifactFile, (File)new File(repoDirectory, layout.pathOf(this.project.getArtifact())));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy artifact file " + artifactFile + " to " + javaDirectory);
        }
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            File dest = new File(repoDirectory, layout.pathOf(artifact));
            this.getLog().debug((CharSequence)("Adding " + file));
            try {
                FileUtils.copyFile((File)file, (File)dest);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + file + " into " + javaDirectory, (Exception)e);
            }
            list.add(repoDirectory.getName() + "/" + layout.pathOf(artifact));
        }
        return list;
    }

    private void writeInfoPlist(File infoPlist, List files) throws MojoExecutionException {
        int i;
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mainClass", (Object)this.mainClass);
        velocityContext.put("cfBundleExecutable", (Object)this.javaApplicationStub.getName());
        velocityContext.put("vmOptions", (Object)this.vmOptions);
        velocityContext.put("bundleName", (Object)this.bundleName);
        velocityContext.put("iconFile", (Object)(this.iconFile == null ? "GenericJavaApp.icns" : this.iconFile.getName()));
        velocityContext.put("version", (Object)this.version);
        velocityContext.put("jvmVersion", (Object)this.jvmVersion);
        StringBuffer jarFilesBuffer = new StringBuffer();
        jarFilesBuffer.append("<array>");
        for (i = 0; i < files.size(); ++i) {
            String name = (String)files.get(i);
            jarFilesBuffer.append("<string>");
            jarFilesBuffer.append("$JAVAROOT/").append(name);
            jarFilesBuffer.append("</string>");
        }
        if (this.additionalClasspath != null) {
            for (i = 0; i < this.additionalClasspath.size(); ++i) {
                String pathElement = (String)this.additionalClasspath.get(i);
                jarFilesBuffer.append("<string>");
                jarFilesBuffer.append(pathElement);
                jarFilesBuffer.append("</string>");
            }
        }
        jarFilesBuffer.append("</array>");
        velocityContext.put("classpath", (Object)jarFilesBuffer.toString());
        try {
            String encoding = this.detectEncoding(this.dictionaryFile, velocityContext);
            this.getLog().debug((CharSequence)("Detected encoding " + encoding + " for dictionary file " + this.dictionaryFile));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlist), encoding);
            this.velocity.getEngine().mergeTemplate(this.dictionaryFile, encoding, (Context)velocityContext, (Writer)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write Info.plist to file " + infoPlist, (Exception)e);
        }
        catch (ParseErrorException e) {
            throw new MojoExecutionException("Error parsing " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("Could not find resource for template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (MethodInvocationException e) {
            throw new MojoExecutionException("MethodInvocationException occured merging Info.plist template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured merging Info.plist template " + this.dictionaryFile, e);
        }
    }

    private String detectEncoding(String dictionaryFile, VelocityContext velocityContext) throws Exception {
        StringWriter sw = new StringWriter();
        this.velocity.getEngine().mergeTemplate(dictionaryFile, "utf-8", (Context)velocityContext, (Writer)sw);
        return new DefaultEncodingDetector().detectXmlEncoding(new ByteArrayInputStream(sw.toString().getBytes("utf-8")));
    }

    private void copyResources(List fileSets) throws MojoExecutionException {
        String[] emptyStrArray = new String[]{};
        for (FileSet fileSet : fileSets) {
            File resourceDirectory = new File(fileSet.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(this.project.getBasedir(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) {
                this.getLog().info((CharSequence)("Additional resource directory does not exist: " + resourceDirectory));
                continue;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resourceDirectory);
            if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty()) {
                scanner.setIncludes(fileSet.getIncludes().toArray(emptyStrArray));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty()) {
                scanner.setExcludes(fileSet.getExcludes().toArray(emptyStrArray));
            }
            if (fileSet.isUseDefaultExcludes()) {
                scanner.addDefaultExcludes();
            }
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLog().info((CharSequence)("Copying " + includedFiles.size() + " additional resource" + (includedFiles.size() > 1 ? "s" : "")));
            for (String destination : includedFiles) {
                File source = new File(resourceDirectory, destination);
                File destinationFile = new File(this.buildDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyFile((File)source, (File)destinationFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying additional resource " + source, (Exception)e);
                }
            }
        }
    }

    private void copyElements() throws MojoExecutionException {
        for (CopyElement element : this.copyElements) {
            Path source = FileSystems.getDefault().getPath(element.getSource(), new String[0]);
            String destanationDirPath = element.getDestinationDirPath();
            if (destanationDirPath != null) {
                destanationDirPath = destanationDirPath.startsWith(File.separator) ? destanationDirPath : File.separator + destanationDirPath;
                destanationDirPath = destanationDirPath.endsWith(File.separator) ? destanationDirPath : destanationDirPath + File.separator;
                File dirPath = new File(this.buildDirectory.getAbsolutePath() + destanationDirPath);
                if (!dirPath.exists()) {
                    dirPath.mkdirs();
                }
            }
            if (element.getDestination() == null) {
                int idxOfSeparator = element.getSource().lastIndexOf(File.separator);
                String newDst = element.getSource().substring(idxOfSeparator + 1, element.getSource().length());
                element.setDestination(newDst);
            }
            Path destanation = FileSystems.getDefault().getPath(this.buildDirectory.getPath(), (destanationDirPath == null ? "" : destanationDirPath) + element.getDestination());
            try {
                Files.copy(source, destanation, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying element " + source, (Exception)e);
            }
        }
    }

    private void createApplicationSymbolicLink() throws MojoExecutionException {
        String pathToLink = this.buildDirectory.getPath() + "/Applications";
        Path link = FileSystems.getDefault().getPath(pathToLink, new String[0]);
        Path target = FileSystems.getDefault().getPath("/Applications", new String[0]);
        try {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating applications symbolic link " + e);
        }
    }

    private void removeApplicationLink() throws MojoExecutionException {
        String pathToLink = this.buildDirectory.getPath() + "/Applications";
        Path link = FileSystems.getDefault().getPath(pathToLink, new String[0]);
        try {
            Files.delete(link);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error deleting applications symbolic link " + e);
        }
    }
}

