/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.osxappbundle.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.osxappbundle.encoding.EncodingDetector;

public class DefaultEncodingDetector
implements EncodingDetector {
    private Pattern pattern = Pattern.compile("<?(xml|XML).*encoding=\"(.*)\"");
    private static final String DEFAULT_ENCODING = "utf-8";

    @Override
    public String detectXmlEncoding(InputStream inputStream) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("utf not supported encoding", e);
        }
        char[] buffer = new char[1000];
        try {
            int read = reader.read(buffer);
            String string = new String(buffer, 0, read);
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.find()) {
                return matcher.group(2);
            }
            return DEFAULT_ENCODING;
        }
        catch (IOException e) {
            return DEFAULT_ENCODING;
        }
    }
}

