/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer;

import com.akamai.edgegrid.signer.NullSafeComparator;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ClientCredential
implements Comparable<ClientCredential> {
    public static final int DEFAULT_MAX_BODY_SIZE_IN_BYTES = 131072;
    private static Comparator<Integer> integerComparator = new NullSafeComparator<Integer>();
    private static Comparator<String> stringComparator = new NullSafeComparator<String>();
    private String accessToken;
    private String clientSecret;
    private String clientToken;
    private TreeSet<String> headersToSign;
    private String host;
    private Integer maxBodySize;

    ClientCredential(ClientCredentialBuilder b) {
        this.accessToken = b.accessToken;
        this.clientSecret = b.clientSecret;
        this.clientToken = b.clientToken;
        this.headersToSign = b.headersToSign;
        this.host = b.host;
        this.maxBodySize = b.maxBodySize;
    }

    public static ClientCredentialBuilder builder() {
        return new ClientCredentialBuilder();
    }

    @Override
    public int compareTo(ClientCredential that) {
        if (that == null) {
            return 1;
        }
        int comparison = 0;
        comparison = stringComparator.compare(this.accessToken, that.accessToken);
        if (comparison == 0) {
            comparison = stringComparator.compare(this.clientSecret, that.clientSecret);
        }
        if (comparison == 0) {
            comparison = stringComparator.compare(this.clientToken, that.clientToken);
        }
        if (comparison == 0) {
            comparison = stringComparator.compare(this.host, that.host);
        }
        if (comparison == 0) {
            comparison = integerComparator.compare(this.maxBodySize, that.maxBodySize);
        }
        return comparison;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ClientCredential that = (ClientCredential)o;
        return this.compareTo(that) == 0;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Set<String> getHeadersToSign() {
        return this.headersToSign;
    }

    public String getHost() {
        return this.host;
    }

    public int getMaxBodySize() {
        if (this.maxBodySize == null) {
            return 131072;
        }
        return this.maxBodySize;
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.clientSecret, this.clientToken, this.headersToSign, this.host, this.maxBodySize);
    }

    public String toString() {
        return "[ " + "accessToken: " + this.accessToken + "; " + "clientSecret: " + this.clientSecret + "; " + "clientToken: " + this.clientToken + "; " + "headersToSign: " + this.headersToSign + "; " + "host: " + this.host + "; " + "maxBodySize: " + this.getMaxBodySize() + " ]";
    }

    public static class ClientCredentialBuilder {
        private String accessToken;
        private String clientSecret;
        private String clientToken;
        private TreeSet<String> headersToSign = new TreeSet();
        private String host;
        private Integer maxBodySize;

        public ClientCredentialBuilder clientToken(String clientToken) {
            if (Objects.isNull(clientToken) || "".equals(clientToken)) {
                throw new IllegalArgumentException("clientToken cannot be empty");
            }
            this.clientToken = clientToken;
            return this;
        }

        public ClientCredentialBuilder clientSecret(String clientSecret) {
            if (Objects.isNull(clientSecret) || "".equals(clientSecret)) {
                throw new IllegalArgumentException("clientSecret cannot be empty");
            }
            this.clientSecret = clientSecret;
            return this;
        }

        public ClientCredentialBuilder accessToken(String accessToken) {
            if (Objects.isNull(accessToken) || "".equals(accessToken)) {
                throw new IllegalArgumentException("accessToken cannot be empty");
            }
            this.accessToken = accessToken;
            return this;
        }

        public ClientCredentialBuilder headersToSign(Set<String> headersToSign) {
            for (String headerName : headersToSign) {
                this.headerToSign(headerName);
            }
            return this;
        }

        public ClientCredentialBuilder headerToSign(String headerName) {
            if (Objects.isNull(headerName) || "".equals(headerName)) {
                throw new IllegalArgumentException("headerName cannot be empty");
            }
            this.headersToSign.add(headerName.toLowerCase());
            return this;
        }

        public ClientCredentialBuilder host(String host) {
            if (Objects.isNull(host) || "".equals(host)) {
                throw new IllegalArgumentException("host cannot be empty");
            }
            this.host = host;
            return this;
        }

        public ClientCredentialBuilder maxBodySize(int maxBodySize) {
            this.maxBodySize = maxBodySize;
            return this;
        }

        public ClientCredential build() {
            Objects.requireNonNull(this.accessToken, "accessToken cannot be empty");
            Objects.requireNonNull(this.clientSecret, "clientSecret cannot be empty");
            Objects.requireNonNull(this.clientToken, "clientToken cannot be empty");
            Objects.requireNonNull(this.host, "host cannot be empty");
            return new ClientCredential(this);
        }
    }
}

