/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer;

import com.akamai.edgegrid.signer.NullSafeComparator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Request
implements Comparable<Request> {
    private static Comparator<String> stringComparator = new NullSafeComparator<String>();
    private static Comparator<URI> uriComparator = new NullSafeComparator<URI>();
    private final byte[] body;
    private final String method;
    private final URI uri;
    private final Map<String, String> headers;

    private Request(RequestBuilder b) {
        this.body = b.body;
        this.method = b.method;
        this.headers = b.headers;
        this.uri = b.uri;
    }

    public static RequestBuilder builder() {
        return new RequestBuilder();
    }

    @Override
    public int compareTo(Request that) {
        if (that == null) {
            return 1;
        }
        int comparison = 0;
        comparison = uriComparator.compare(this.uri, that.uri);
        if (comparison == 0) {
            comparison = stringComparator.compare(this.method, that.method);
        }
        if (comparison == 0) {
            comparison = Integer.compare(this.body.length, that.body.length);
        }
        if (comparison == 0) {
            for (int i = 0; i < this.body.length && comparison == 0; ++i) {
                byte left = this.body[i];
                byte right = that.body[i];
                comparison = left < right ? -1 : (left > right ? 1 : 0);
            }
        }
        if (comparison == 0) {
            comparison = Integer.compare(this.headers.size(), that.headers.size());
        }
        if (comparison == 0) {
            for (String key : this.headers.keySet()) {
                if (!that.headers.containsKey(key)) {
                    comparison = 1;
                    break;
                }
                comparison = this.headers.get(key).compareTo(that.headers.get(key));
                if (comparison == 0) continue;
                break;
            }
        }
        return comparison;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Request that = (Request)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.body, this.headers, this.method, this.uri);
    }

    public String toString() {
        return "[ " + "body: " + this.body + "; " + "headers: " + this.headers + "; " + "method: " + this.method + "; " + "uri: " + this.uri + " ]";
    }

    byte[] getBody() {
        return this.body;
    }

    Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    String getMethod() {
        return this.method;
    }

    URI getUri() {
        return this.uri;
    }

    public static class RequestBuilder {
        private byte[] body = new byte[0];
        private Map<String, String> headers = new HashMap<String, String>();
        private String method;
        private URI uri;

        public RequestBuilder body(byte[] requestBody) {
            if (requestBody != null && requestBody.length != 0) {
                this.body = Arrays.copyOf(requestBody, requestBody.length);
            }
            return this;
        }

        public RequestBuilder header(String headerName, String value) {
            if (headerName == null || "".equals(headerName)) {
                throw new IllegalArgumentException("headerName cannot be empty");
            }
            if (value == null || "".equals(value)) {
                throw new IllegalArgumentException("value cannot be empty");
            }
            if (this.headers.containsKey(headerName = headerName.toLowerCase())) {
                throw new IllegalArgumentException("Duplicate header found: " + headerName);
            }
            this.headers.put(headerName, value);
            return this;
        }

        public RequestBuilder headers(Map<String, String> headers) {
            Objects.requireNonNull(headers, "headers cannot be null");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public RequestBuilder method(String method) {
            if (Objects.isNull(method) || "".equals(method)) {
                throw new IllegalArgumentException("method cannot be empty");
            }
            this.method = method;
            return this;
        }

        public RequestBuilder uri(String uri) {
            if (uri == null || "".equals(uri)) {
                throw new IllegalArgumentException("uri cannot be empty");
            }
            return this.uri(URI.create(uri));
        }

        public RequestBuilder uri(URI uri) {
            Objects.requireNonNull(uri, "uri cannot be empty");
            try {
                this.uri = new URI(null, null, uri.getPath(), uri.getRawQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Error setting URI", e);
            }
            return this;
        }

        public Request build() {
            Objects.requireNonNull(this.body, "body cannot be empty");
            Objects.requireNonNull(this.uri, "uriWithQuery cannot be empty");
            if (Objects.isNull(this.method) || "".equals(this.method)) {
                throw new IllegalArgumentException("method cannot be empty");
            }
            return new Request(this);
        }
    }
}

