/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer.googlehttpclient;

import com.akamai.edgegrid.signer.AbstractEdgeGridRequestSigner;
import com.akamai.edgegrid.signer.ClientCredential;
import com.akamai.edgegrid.signer.ClientCredentialProvider;
import com.akamai.edgegrid.signer.Request;
import com.akamai.edgegrid.signer.exceptions.RequestSigningException;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Types;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;

public class GoogleHttpClientEdgeGridRequestSigner
extends AbstractEdgeGridRequestSigner<HttpRequest, HttpRequest> {
    public GoogleHttpClientEdgeGridRequestSigner(ClientCredential clientCredential) {
        super(clientCredential);
    }

    public GoogleHttpClientEdgeGridRequestSigner(ClientCredentialProvider clientCredentialProvider) {
        super(clientCredentialProvider);
    }

    protected URI requestUri(HttpRequest request) {
        return request.getUrl().toURI();
    }

    protected Request map(HttpRequest request) {
        Request.RequestBuilder builder = Request.builder().method(request.getRequestMethod()).uri(request.getUrl().toURI()).body(this.serializeContent(request));
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Iterable || value.getClass().isArray()) {
                for (Object repeatedValue : Types.iterableOf(value)) {
                    builder.header((String)entry.getKey(), GoogleHttpClientEdgeGridRequestSigner.toStringValue(repeatedValue));
                }
                continue;
            }
            builder.header((String)entry.getKey(), GoogleHttpClientEdgeGridRequestSigner.toStringValue(value));
        }
        return builder.build();
    }

    public void sign(HttpRequest request) throws RequestSigningException {
        this.sign(request, request);
    }

    protected void setAuthorization(HttpRequest request, String signature) {
        request.getHeaders().setAuthorization(signature);
    }

    private byte[] serializeContent(HttpRequest request) {
        try {
            HttpContent content = request.getContent();
            if (content == null) {
                return new byte[0];
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            content.writeTo((OutputStream)bos);
            byte[] contentBytes = bos.toByteArray();
            if (!content.retrySupported()) {
                ByteArrayContent newContent = new ByteArrayContent(content.getType(), contentBytes);
                request.setContent((HttpContent)newContent);
            }
            return contentBytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toStringValue(Object headerValue) {
        return headerValue instanceof Enum ? FieldInfo.of((Enum)((Enum)headerValue)).getName() : headerValue.toString();
    }

    protected void setHost(HttpRequest request, String host, URI uri) {
        if (request.getHeaders().containsKey((Object)"host")) {
            request.getHeaders().put("host", (Object)host);
        }
        request.setUrl(new GenericUrl(uri));
    }
}

