/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.alexecollins.docker.orchestration.CollectingLogContainerResultCallback;
import com.alexecollins.docker.orchestration.DefinitionFilter;
import com.alexecollins.docker.orchestration.DockerOrchestratorBuilder;
import com.alexecollins.docker.orchestration.DockerfileValidator;
import com.alexecollins.docker.orchestration.FileOrchestrator;
import com.alexecollins.docker.orchestration.OrchestrationException;
import com.alexecollins.docker.orchestration.PatternMatchingStartupResultCallback;
import com.alexecollins.docker.orchestration.Repo;
import com.alexecollins.docker.orchestration.Tail;
import com.alexecollins.docker.orchestration.TailFactory;
import com.alexecollins.docker.orchestration.model.BuildFlag;
import com.alexecollins.docker.orchestration.model.CleanFlag;
import com.alexecollins.docker.orchestration.model.Conf;
import com.alexecollins.docker.orchestration.model.ContainerConf;
import com.alexecollins.docker.orchestration.model.HealthChecks;
import com.alexecollins.docker.orchestration.model.Id;
import com.alexecollins.docker.orchestration.model.Link;
import com.alexecollins.docker.orchestration.model.LogPattern;
import com.alexecollins.docker.orchestration.model.Ping;
import com.alexecollins.docker.orchestration.model.VolumeFrom;
import com.alexecollins.docker.orchestration.plugin.api.Plugin;
import com.alexecollins.docker.orchestration.util.Links;
import com.alexecollins.docker.orchestration.util.Pinger;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.InternalServerErrorException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.Repository;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerOrchestrator {
    @Deprecated
    public static final FileFilter DEFAULT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return false;
        }
    };
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(DockerOrchestrator.class);
    private static final String CONTAINER_IP_PATTERN = "__CONTAINER.IP__";
    private final Logger logger;
    private final DockerClient docker;
    private final TailFactory tailFactory;
    private final Repo repo;
    private final FileOrchestrator fileOrchestrator;
    private final Set<BuildFlag> buildFlags;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final DockerfileValidator dockerfileValidator;
    private final DefinitionFilter definitionFilter;
    private final boolean permissionErrorTolerant;

    @Deprecated
    public DockerOrchestrator(DockerClient docker, File src, File workDir, File rootDir, String user, String project, FileFilter filter, Properties properties) {
        this(docker, src, workDir, rootDir, user, project, filter, properties, EnumSet.noneOf(BuildFlag.class));
    }

    @Deprecated
    public DockerOrchestrator(DockerClient docker, File src, File workDir, File rootDir, String user, String project, FileFilter filter, Properties properties, Set<BuildFlag> buildFlags) {
        this(docker, new Repo(user, project, src, properties), new FileOrchestrator(workDir, rootDir, filter, properties), buildFlags, DEFAULT_LOGGER, TailFactory.DEFAULT, new DockerfileValidator(), DefinitionFilter.ANY, false);
    }

    DockerOrchestrator(DockerClient docker, Repo repo, FileOrchestrator fileOrchestrator, Set<BuildFlag> buildFlags, Logger logger, TailFactory tailFactory, DockerfileValidator dockerfileValidator, DefinitionFilter definitionFilter, boolean permissionErrorTolerant) {
        if (docker == null) {
            throw new IllegalArgumentException("docker is null");
        }
        if (repo == null) {
            throw new IllegalArgumentException("repo is null");
        }
        if (buildFlags == null) {
            throw new IllegalArgumentException("buildFlags is null");
        }
        if (fileOrchestrator == null) {
            throw new IllegalArgumentException("fileOrchestrator is null");
        }
        if (dockerfileValidator == null) {
            throw new IllegalArgumentException("dockerfileValidator is null");
        }
        if (definitionFilter == null) {
            throw new IllegalArgumentException("definitionFilter is null");
        }
        this.docker = docker;
        this.tailFactory = tailFactory;
        this.repo = repo;
        this.fileOrchestrator = fileOrchestrator;
        this.buildFlags = buildFlags;
        this.logger = logger;
        this.dockerfileValidator = dockerfileValidator;
        this.definitionFilter = definitionFilter;
        this.permissionErrorTolerant = permissionErrorTolerant;
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            this.plugins.add(plugin);
            logger.info("Loaded " + plugin.getClass() + " plugin");
        }
    }

    public static DockerOrchestratorBuilder builder() {
        return new DockerOrchestratorBuilder();
    }

    private static boolean isPermissionError(InternalServerErrorException e) {
        return e.getMessage().contains("operation not permitted");
    }

    private static List<LogPattern> sortedLogPatterns(List<LogPattern> logPatterns) {
        ArrayList<LogPattern> pending = new ArrayList<LogPattern>(logPatterns);
        Collections.sort(pending, new Comparator<LogPattern>(){

            @Override
            public int compare(LogPattern o1, LogPattern o2) {
                return o1.getTimeout() - o2.getTimeout();
            }
        });
        return pending;
    }

    static String logPatternsToString(List<LogPattern> pending) {
        return Lists.transform(pending, (Function)new Function<LogPattern, String>(){

            public String apply(LogPattern input) {
                return String.format("\"%s\"", input.getPattern().pattern());
            }
        }).toString();
    }

    private static String buildResponseItemToString(ResponseItem item) {
        if (item.getStream() != null) {
            return item.getStream();
        }
        if (item.getStatus() != null) {
            if (item.getProgress() != null) {
                return item.getStatus() + ": " + item.getProgress();
            }
            return item.getStatus();
        }
        if (item.getError() != null) {
            return item.getError();
        }
        return item.toString();
    }

    public void clean() {
        this.clean(CleanFlag.CONTAINER_AND_IMAGE);
    }

    public void cleanContainers() {
        this.clean(CleanFlag.CONTAINER_ONLY);
    }

    public void clean(CleanFlag cleanFlag) {
        for (Id id : this.repo.ids(true)) {
            if (!this.inclusive(id)) continue;
            this.stop(id);
            this.clean(id, cleanFlag);
        }
    }

    private boolean inclusive(Id id) {
        Conf conf = this.conf(id);
        if (!this.definitionFilter.test(id, conf)) {
            this.logger.info("Not including " + id + ", filtered out");
            return false;
        }
        if (!conf.isEnabled()) {
            this.logger.info("Not including " + id + ", not enabled");
            return false;
        }
        return true;
    }

    void clean(Id id) {
        this.clean(id, CleanFlag.CONTAINER_AND_IMAGE);
    }

    void clean(Id id, CleanFlag flag) {
        this.cleanContainer(id);
        if (flag == CleanFlag.CONTAINER_AND_IMAGE) {
            this.cleanImage(id);
        }
    }

    private void cleanImage(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        String imageId = null;
        try {
            imageId = this.findImageId(id);
        }
        catch (NotFoundException e) {
            this.logger.warn("Image " + id + " not found");
        }
        catch (DockerException e) {
            throw new OrchestrationException(e);
        }
        if (imageId != null) {
            this.logger.info("Removing image " + imageId);
            try {
                this.docker.removeImageCmd(imageId).withForce().exec();
            }
            catch (DockerException e) {
                this.logger.warn(e.getMessage());
            }
        }
    }

    private void cleanContainer(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.stop(id);
        this.logger.info("Cleaning container " + id);
        for (Container container : this.findAllContainers(id)) {
            try {
                this.removeContainer(container);
            }
            catch (DockerException e) {
                throw new OrchestrationException(e);
            }
        }
    }

    private List<Container> findRunningContainers(Id id) {
        return this.findContainers(id, false);
    }

    private List<Container> findAllContainers(Id id) {
        return this.findContainers(id, true);
    }

    private List<Container> findContainers(Id id, boolean allContainers) {
        ArrayList<Container> matchingContainers = new ArrayList<Container>();
        for (Container container : (List)this.docker.listContainersCmd().withShowAll(allContainers).exec()) {
            boolean imageNameMatches = container.getImage().equals(this.repo.imageName(id));
            String[] containerNames = container.getNames();
            if (containerNames == null) continue;
            boolean containerNameMatches = Arrays.asList(containerNames).contains(this.containerName(id));
            if (!imageNameMatches && !containerNameMatches) continue;
            matchingContainers.add(container);
        }
        return matchingContainers;
    }

    private String containerName(Id id) {
        Conf conf = this.repo.conf(id);
        if (conf == null) {
            throw new OrchestrationException(String.format("Unable to retrieve container name for id %s", id));
        }
        ContainerConf container = conf.getContainer();
        return container.hasName() ? container.getName() : this.repo.defaultContainerName(id);
    }

    void build(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            this.build(this.prepare(id), id);
        }
        catch (IOException e) {
            throw new OrchestrationException(e);
        }
    }

    private void validate(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            this.dockerfileValidator.validate(this.repo.src(id));
        }
        catch (IOException e) {
            throw new OrchestrationException(e);
        }
    }

    private File prepare(Id id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.logger.info("Preparing " + id);
        return this.fileOrchestrator.prepare(id, this.repo.src(id), this.conf(id));
    }

    private void build(File dockerFolder, Id id) {
        try {
            String tag = this.repo.tag(id);
            this.logger.info("Building " + id + " (" + tag + ")");
            boolean noCache = this.buildNoCache();
            this.logger.info(" - no cache: " + noCache);
            boolean removeIntermediateImages = this.buildRemoveIntermediateImages();
            this.logger.info(" - remove intermediate images: " + removeIntermediateImages);
            boolean quiet = this.buildQuiet();
            this.logger.info(" - quiet: " + quiet);
            boolean pull = this.buildPull();
            this.logger.info(" - pull: " + pull);
            BuildImageCmd build = this.docker.buildImageCmd(dockerFolder).withNoCache(noCache).withRemove(removeIntermediateImages).withQuiet(quiet).withTag(tag).withPull(pull);
            BuildImageResultCallback callback = new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    DockerOrchestrator.this.logger.info(DockerOrchestrator.buildResponseItemToString((ResponseItem)item).replaceAll("\\r?\\n$", ""));
                }
            };
            String imageId = ((BuildImageResultCallback)build.exec((ResultCallback)callback)).awaitImageId();
            for (String otherTag : this.repo.conf(id).getTags()) {
                int lastIndexOfColon = otherTag.lastIndexOf(58);
                if (lastIndexOfColon <= -1) continue;
                String repositoryName = otherTag.substring(0, lastIndexOfColon);
                String tagName = otherTag.substring(lastIndexOfColon + 1);
                this.docker.tagImageCmd(imageId, repositoryName, tagName).withForce().exec();
            }
        }
        catch (DockerException e) {
            throw new OrchestrationException(e);
        }
    }

    private String findImageId(Id id) {
        String imageTag = this.repo.tag(id);
        this.logger.debug("Converting {} ({}) to image id.", (Object)id, (Object)imageTag);
        List images = (List)this.docker.listImagesCmd().exec();
        for (Image i : images) {
            for (String tag : i.getRepoTags()) {
                if (!tag.startsWith(imageTag)) continue;
                this.logger.debug("Using {} ({}) for {}. It matches (enough) to {}.", new Object[]{i.getId(), tag, id.toString(), imageTag});
                return i.getId();
            }
        }
        this.logger.debug("could not find image ID for \"" + id + "\" (tag \"" + imageTag + "\")");
        return null;
    }

    private boolean buildQuiet() {
        return this.haveBuildFlag(BuildFlag.QUIET);
    }

    private boolean buildPull() {
        return this.haveBuildFlag(BuildFlag.PULL);
    }

    private boolean buildRemoveIntermediateImages() {
        return this.haveBuildFlag(BuildFlag.REMOVE_INTERMEDIATE_IMAGES);
    }

    private boolean buildNoCache() {
        return this.haveBuildFlag(BuildFlag.NO_CACHE);
    }

    private boolean haveBuildFlag(BuildFlag flag) {
        return this.buildFlags.contains(flag);
    }

    private void start(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.logger.info("Starting " + id);
        try {
            if (!this.imageExists(id)) {
                this.logger.info("Image does not exist, so building it");
                this.build(id);
            }
        }
        catch (DockerException e) {
            throw new OrchestrationException(e);
        }
        try {
            Container existingContainer = this.findContainer(id);
            if (existingContainer == null) {
                this.logger.info("No existing container for id {} so creating and starting new one", (Object)id);
                this.startContainer(this.createNewContainer(id));
            } else if (!this.isImageIdFromContainerMatchingProvidedImageId(existingContainer.getId(), id)) {
                this.logger.info("Image IDs do not match, removing container and creating new one from image");
                this.removeContainer(existingContainer);
                this.startContainer(this.createNewContainer(id));
            } else if (this.isRunning(id)) {
                this.logger.info("Container already running");
            } else {
                this.logger.info("Starting existing container " + existingContainer.getId());
                this.startContainer(existingContainer.getId());
            }
            Conf conf = this.conf(id);
            for (Plugin plugin : this.plugins) {
                plugin.started(id, conf);
            }
            this.sleep(id);
            this.healthCheck(id);
        }
        catch (Exception e) {
            this.logger.error("Error starting container with id " + id + ": " + e.getMessage());
            throw new OrchestrationException(e);
        }
        Container container = this.findContainer(id);
        if (container == null) {
            throw new OrchestrationException("Could not find container with id " + id);
        }
        Tail tail = this.tailFactory.newTail(this.docker, container, this.logger);
        tail.start();
    }

    private Container findContainer(Id id) {
        List<Container> containerIds = this.findAllContainers(id);
        return containerIds.isEmpty() ? null : containerIds.get(0);
    }

    private boolean imageExists(Id id) throws DockerException {
        return this.findImageId(id) != null;
    }

    private void removeContainer(Container existingContainer) {
        this.logger.info("Removing container " + existingContainer.getId());
        try {
            this.docker.removeContainerCmd(existingContainer.getId()).withForce().withRemoveVolumes(true).exec();
        }
        catch (InternalServerErrorException e) {
            if (this.permissionErrorTolerant && DockerOrchestrator.isPermissionError(e)) {
                this.logger.warn(String.format("ignoring %s when removing container as we are configured to be permission error tolerant", new Object[]{e}));
            }
            throw e;
        }
    }

    private void sleep(Id id) {
        try {
            int sleep = this.conf(id).getSleep();
            if (sleep == 0) {
                return;
            }
            this.logger.info(String.format("Sleeping for %dms", sleep));
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            throw new OrchestrationException(e);
        }
    }

    private void waitForLogPatterns(Id id, List<LogPattern> logPatterns) {
        Container container;
        if (logPatterns == null || logPatterns.isEmpty()) {
            return;
        }
        try {
            container = this.findContainer(id);
        }
        catch (DockerException e) {
            throw new OrchestrationException(e);
        }
        if (container == null) {
            this.logger.warn(String.format("Can not find container %s, not waiting", id));
            return;
        }
        List<LogPattern> pendingPatterns = DockerOrchestrator.sortedLogPatterns(logPatterns);
        this.logger.info("Waiting for {} to appear in output", (Object)DockerOrchestrator.logPatternsToString(pendingPatterns));
        LogContainerCmd logContainerCmd = this.docker.logContainerCmd(container.getId()).withStdErr().withStdOut().withTailAll().withFollowStream();
        PatternMatchingStartupResultCallback callback = new PatternMatchingStartupResultCallback(this.logger, pendingPatterns, id);
        int timeoutMax = 0;
        for (LogPattern pattern : pendingPatterns) {
            timeoutMax = Math.max(timeoutMax, pattern.getTimeout());
        }
        try {
            ((PatternMatchingStartupResultCallback)logContainerCmd.exec((ResultCallback)callback)).awaitCompletion(timeoutMax, TimeUnit.MILLISECONDS);
            if (!callback.isComplete()) {
                callback.cancel();
                throw new OrchestrationException(String.format("timeout after %d while waiting for log-patterns in %s's log", timeoutMax, id));
            }
        }
        catch (InterruptedException e) {
            throw new OrchestrationException(String.format("Interrupt while waiting for log-patterns in %s's log", timeoutMax, id));
        }
        if (!callback.isComplete()) {
            throw new OrchestrationException(String.format("%s's log ended before %s appeared in output", id, DockerOrchestrator.logPatternsToString(pendingPatterns)));
        }
    }

    private boolean isImageIdFromContainerMatchingProvidedImageId(String containerId, Id id) {
        try {
            String containerImageId = this.lookupImageIdFromContainer(containerId);
            String imageId = this.findImageId(id);
            return containerImageId.equals(imageId);
        }
        catch (DockerException e) {
            this.logger.error("Unable to find image with id " + id, (Throwable)e);
            throw new OrchestrationException(e);
        }
    }

    private String lookupImageIdFromContainer(String containerId) {
        try {
            InspectContainerResponse containerInspectResponse = this.docker.inspectContainerCmd(containerId).exec();
            return containerInspectResponse.getImageId();
        }
        catch (DockerException e) {
            this.logger.error("Unable to inspect container " + containerId, (Throwable)e);
            throw new OrchestrationException(e);
        }
    }

    private void startContainer(String idOfContainerToStart) {
        try {
            this.docker.startContainerCmd(idOfContainerToStart).exec();
        }
        catch (Exception e) {
            this.logger.error("Unable to start container " + idOfContainerToStart, (Throwable)e);
            throw new OrchestrationException(e);
        }
    }

    private Conf conf(Id id) {
        return this.repo.conf(id);
    }

    private String createNewContainer(Id id) throws DockerException {
        CreateContainerResponse createResponse;
        String[] warnings;
        CreateContainerCmd cmd = this.docker.createContainerCmd(this.findImageId(id));
        Conf conf = this.conf(id);
        cmd.withPublishAllPorts(true);
        cmd.withPrivileged(conf.isPrivileged());
        cmd.withNetworkMode(conf.getNetworkMode());
        com.github.dockerjava.api.model.Link[] links = this.links(id);
        this.logger.info(" - links " + conf.getLinks());
        cmd.withLinks(links);
        this.logger.info(" - volumesFrom " + conf.getVolumesFrom());
        VolumesFrom[] volumesFrom = this.volumesFrom(id);
        cmd.withVolumesFrom(volumesFrom);
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>();
        for (String e : conf.getPorts()) {
            String[] split = e.split(" ");
            assert (split.length == 1 || split.length == 2);
            int hostPort = Integer.parseInt(split[0]);
            int containerPort = split.length == 2 ? Integer.parseInt(split[1]) : hostPort;
            this.logger.info(" - port " + hostPort + "->" + containerPort);
            portBindings.add(new PortBinding(new Ports.Binding(Integer.valueOf(hostPort)), new ExposedPort(containerPort, InternetProtocol.TCP)));
        }
        cmd.withPortBindings(portBindings.toArray(new PortBinding[portBindings.size()]));
        this.logger.info(" - volumes " + conf.getVolumes());
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        ArrayList<Bind> binds = new ArrayList<Bind>();
        for (Map.Entry entry : conf.getVolumes().entrySet()) {
            String volumePath = (String)entry.getKey();
            Volume volume = new Volume(volumePath);
            String hostPath = (String)entry.getValue();
            if (hostPath != null && !hostPath.trim().equals("")) {
                this.logger.info(" - volumes " + volumePath + " <- " + hostPath);
                binds.add(new Bind(hostPath, volume));
                continue;
            }
            volumes.add(volume);
        }
        cmd.withVolumes(volumes.toArray(new Volume[volumes.size()]));
        cmd.withBinds(binds.toArray(new Bind[binds.size()]));
        cmd.withName(this.repo.containerName(id));
        this.logger.info(" - env " + conf.getEnv());
        cmd.withEnv(this.asEnvList(conf.getEnv()));
        if (!conf.getExtraHosts().isEmpty()) {
            List extraHosts = conf.getExtraHosts();
            cmd.withExtraHosts(extraHosts.toArray(new String[extraHosts.size()]));
            this.logger.info(" - extra hosts " + conf.getExtraHosts());
        }
        if ((warnings = (createResponse = cmd.exec()).getWarnings()) != null) {
            for (String warning : warnings) {
                this.logger.warn("Warning during container creation: " + warning);
            }
        }
        String returnId = createResponse.getId();
        this.logger.info("Created new container " + returnId + " for " + id);
        return returnId;
    }

    private String[] asEnvList(Map<String, String> env) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            list.add(entry.getKey() + "=" + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean isRunning(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        boolean running = false;
        Container candidate = this.findContainer(id);
        for (Container container : (List)this.docker.listContainersCmd().withShowAll(false).exec()) {
            running |= candidate != null && candidate.getId().equals(container.getId());
        }
        return running;
    }

    private void healthCheck(Id id) {
        HealthChecks healthChecks = this.conf(id).getHealthChecks();
        this.waitForLogPatterns(id, healthChecks.getLogPatterns());
        this.waitForPings(id, healthChecks.getPings());
    }

    private void waitForPings(Id id, List<Ping> pings) {
        for (Ping ping : pings) {
            this.waitForPing(id, ping);
        }
    }

    private void waitForPing(Id id, Ping ping) {
        URI uri;
        if (ping.getUrl().toString().contains(CONTAINER_IP_PATTERN)) {
            try {
                uri = new URI(ping.getUrl().toString().replace(CONTAINER_IP_PATTERN, this.getIPAddress(id)));
            }
            catch (URISyntaxException e) {
                throw new OrchestrationException("Bad health check URI syntax: " + e.getMessage() + ", input: " + e.getInput() + ", index:" + e.getIndex());
            }
        } else {
            uri = ping.getUrl();
        }
        this.logger.info(String.format("Pinging %s for pattern \"%s\"", uri, ping.getPattern()));
        if (!Pinger.ping(uri, ping.getPattern(), ping.getTimeout(), ping.isSslVerify())) {
            throw new OrchestrationException("timeout waiting for " + uri + " for " + ping.getTimeout() + " with pattern " + ping.getPattern());
        }
    }

    private com.github.dockerjava.api.model.Link[] links(Id id) {
        List links = this.conf(id).getLinks();
        com.github.dockerjava.api.model.Link[] out = new com.github.dockerjava.api.model.Link[links.size()];
        HashSet seenAliases = Sets.newHashSet();
        for (int i = 0; i < links.size(); ++i) {
            Link link = (Link)links.get(i);
            Container container = this.findContainer(link.getId());
            if (container == null) {
                throw new OrchestrationException(String.format("Could not find container for link %s", link.getId()));
            }
            String name = Links.name(container.getNames());
            String alias = link.getAlias();
            if (seenAliases.contains(alias)) {
                throw new OrchestrationException(String.format("Alias %s already used for a link with container %s", alias, id));
            }
            seenAliases.add(alias);
            out[i] = new com.github.dockerjava.api.model.Link(name, alias);
        }
        return out;
    }

    private VolumesFrom[] volumesFrom(Id id) {
        List volumes = this.conf(id).getVolumesFrom();
        VolumesFrom[] out = new VolumesFrom[volumes.size()];
        for (int i = 0; i < volumes.size(); ++i) {
            VolumeFrom volume = (VolumeFrom)volumes.get(i);
            Container container = this.findContainer(volume.getId());
            if (container == null) {
                throw new OrchestrationException(String.format("Can not use volume %s, unable to find corresponding container.", volume.getId()));
            }
            AccessMode accessMode = AccessMode.fromBoolean((boolean)volume.isReadWrite());
            out[i] = new VolumesFrom(volume.getId().toString(), accessMode);
        }
        return out;
    }

    private void stop(Id id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.logger.info("Stopping " + id);
        for (Container container : this.findRunningContainers(id)) {
            this.logger.info("Stopping container " + Arrays.toString(container.getNames()));
            try {
                this.docker.stopContainerCmd(container.getId()).withTimeout(1).exec();
            }
            catch (DockerException e) {
                throw new OrchestrationException(e);
            }
        }
        for (Plugin plugin : this.plugins) {
            plugin.stopped(id, this.conf(id));
        }
    }

    private void copy(Id id, String resource, String hostpath) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.logger.info("Copying " + resource + " from " + id + " to " + hostpath);
        if (this.findContainer(id) == null) {
            this.createNewContainer(id);
        }
        for (Container container : this.findAllContainers(id)) {
            try {
                InputStream is = this.docker.copyFileFromContainerCmd(container.getId(), resource).withHostPath(hostpath).exec();
                TarArchiveInputStream tais = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
                File targetPath = new File(hostpath);
                TarArchiveEntry tarEntry = tais.getNextTarEntry();
                while (tarEntry != null) {
                    File destPath = targetPath;
                    if (targetPath.isDirectory()) {
                        destPath = new File(targetPath, tarEntry.getName());
                    }
                    if (tarEntry.isDirectory() && destPath.isDirectory()) {
                        destPath.mkdirs();
                    } else {
                        Files.copy((InputStream)tais, destPath.toPath(), new CopyOption[0]);
                    }
                    tarEntry = tais.getNextTarEntry();
                }
                tais.close();
                is.close();
            }
            catch (DockerException | IOException | ArchiveException e) {
                throw new OrchestrationException(e);
            }
        }
    }

    public void build() {
        for (Id id : this.ids()) {
            if (!this.inclusive(id)) continue;
            this.build(id);
        }
    }

    public void validate() {
        Exception innerException = null;
        for (Id id : this.ids()) {
            if (!this.inclusive(id)) continue;
            try {
                this.validate(id);
            }
            catch (Exception e) {
                innerException = e;
            }
        }
        if (innerException != null) {
            throw new OrchestrationException(innerException);
        }
    }

    public void start() {
        for (Id id : this.ids()) {
            if (!this.inclusive(id)) continue;
            this.start(id);
        }
    }

    public void copy(String resource, String hostpath) {
        for (Id id : this.ids()) {
            if (!this.inclusive(id)) continue;
            this.copy(id, resource, hostpath);
        }
    }

    public String getIPAddress(Id id) {
        Container container = this.findContainer(id);
        if (container != null && this.repo.conf(id).isExposeContainerIp()) {
            InspectContainerResponse containerInspectResponse = this.docker.inspectContainerCmd(container.getId()).exec();
            return containerInspectResponse.getNetworkSettings().getIpAddress();
        }
        throw new IllegalArgumentException(id + " container IP address is not exposed");
    }

    public Map<String, String> getIPAddresses() {
        HashMap<String, String> idToIpAddressMap = new HashMap<String, String>();
        for (Id id : this.ids()) {
            Conf conf = this.repo.conf(id);
            if (!this.inclusive(id) || !conf.isExposeContainerIp()) continue;
            idToIpAddressMap.put(id.toString(), this.getIPAddress(id));
        }
        return idToIpAddressMap;
    }

    public void stop() {
        for (Id id : this.repo.ids(true)) {
            if (!this.inclusive(id)) continue;
            this.stop(id);
        }
    }

    public List<Id> ids() {
        return this.repo.ids(false);
    }

    public void push() {
        for (Id id : this.ids()) {
            if (!this.inclusive(id)) continue;
            this.push(id);
        }
    }

    private void push(Id id) {
        for (Identifier identifier : this.identifiers(id)) {
            try {
                PushImageCmd pushImageCmd = this.docker.pushImageCmd(identifier.repository.name);
                if (identifier.tag.isPresent()) {
                    pushImageCmd.withTag((String)identifier.tag.get());
                }
                this.logger.info("Pushing " + id + " (" + this.asString(identifier) + ")");
                PushImageResultCallback callback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        super.onNext(item);
                        DockerOrchestrator.this.logger.info(DockerOrchestrator.buildResponseItemToString((ResponseItem)item).replaceAll("\\r?\\n$", ""));
                    }
                };
                ((PushImageResultCallback)pushImageCmd.exec((ResultCallback)callback)).awaitSuccess();
            }
            catch (DockerClientException | DockerException e) {
                throw new OrchestrationException(e);
            }
        }
    }

    private String asString(Identifier identifier) {
        if (identifier == null) {
            return "";
        }
        Optional tag = identifier.tag;
        return identifier.repository.getPath() + (tag.isPresent() ? ":" + (String)tag.get() : "");
    }

    private Iterable<Identifier> identifiers(Id id) {
        return FluentIterable.from(this.repo.tags(id)).transform((Function)new Function<String, Identifier>(){

            public Identifier apply(String tag) {
                String repository = tag.replaceFirst(":[^:]*$", "");
                if (tag.equals(repository)) {
                    return new Identifier(new Repository(repository), null);
                }
                return new Identifier(new Repository(repository), tag.substring(repository.length() + 1));
            }
        }).toSortedSet((Comparator)Ordering.usingToString());
    }

    public boolean isRunning() {
        for (Id id : this.ids()) {
            if (this.isRunning(id)) continue;
            return false;
        }
        return true;
    }

    <P extends Plugin> P getPlugin(Class<P> pluginClass) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().equals(pluginClass)) continue;
            return (P)plugin;
        }
        throw new NoSuchElementException("plugin " + pluginClass + " is not loaded");
    }

    public Map<Id, File> save(File destDir, boolean gzip) {
        HashMap<Id, File> saved = new HashMap<Id, File>();
        for (Id id : this.ids()) {
            String name;
            if (!this.inclusive(id)) continue;
            File outputFile = new File(destDir, id + ".tar" + (gzip ? ".gz" : ""));
            this.logger.info("Saving {} as {}", (Object)id, (Object)outputFile);
            if (!this.imageExists(id)) {
                throw new OrchestrationException("image for " + id + " does not exist");
            }
            Conf conf = this.conf(id);
            String string = name = conf.hasTag() ? conf.getTag() : this.findImageId(id);
            if (!conf.hasTag()) {
                this.logger.warn("Image does NOT have tag. Saving using image ID. Export will be missing 'repositories' data.");
            }
            this.logger.info("Saving image {}", (Object)name);
            try (InputStream in = this.docker.saveImageCmd(name).exec();
                 OutputStream out = gzip ? new GZIPOutputStream(new FileOutputStream(outputFile)) : new FileOutputStream(outputFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                throw new OrchestrationException(e);
            }
            saved.put(id, outputFile);
        }
        return saved;
    }

    public Map<Id, File> saveLogs(File destDir) {
        HashMap<Id, File> saved = new HashMap<Id, File>();
        for (Id id : this.repo.ids(true)) {
            if (!this.inclusive(id)) continue;
            Container container = this.findContainer(id);
            if (container != null) {
                LogContainerCmd logContainerCmd = this.docker.logContainerCmd(container.getId()).withStdErr().withStdOut().withTailAll();
                CollectingLogContainerResultCallback callback = new CollectingLogContainerResultCallback();
                try {
                    ((CollectingLogContainerResultCallback)logContainerCmd.exec((ResultCallback)callback)).awaitCompletion();
                }
                catch (InterruptedException e) {
                    throw new OrchestrationException("Failed to get output of container " + container.getId(), e);
                }
                String logOutput = callback.getLogOutput();
                File outputFile = new File(destDir, id + ".log");
                try {
                    try (FileOutputStream fos = new FileOutputStream(outputFile);){
                        IOUtils.write((String)logOutput, (OutputStream)fos, (Charset)Charsets.UTF_8);
                        this.logger.info("Wrote output of " + container.getId() + " to " + outputFile.getAbsolutePath());
                    }
                    saved.put(id, outputFile);
                    continue;
                }
                catch (IOException e) {
                    throw new OrchestrationException("Failed to write " + outputFile.getAbsolutePath(), e);
                }
            }
            this.logger.warn("Could not find container for image " + id);
        }
        return saved;
    }
}

