/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.alexecollins.docker.orchestration.OrchestrationException;
import com.github.dockerjava.core.GoLangFileMatch;
import com.github.dockerjava.core.GoLangFileMatchException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DockerfileValidator {
    private static final Map<String, Pattern> INSTRUCTIONS_PATTERNS = DockerfileValidator.instructionsPatterns();
    private static final Logger logger = LoggerFactory.getLogger(DockerfileValidator.class);

    DockerfileValidator() {
    }

    private static Map<String, Pattern> instructionsPatterns() {
        Pattern addPattern = Pattern.compile("^(~?[${.}A-z0-9\\/_.-]+|https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\+.~#?&\\/\\/=]*))\\s~?[A-z0-9\\/_.-]+$");
        HashMap<String, Pattern> instructionPatterns = new HashMap<String, Pattern>();
        instructionPatterns.put("FROM", Pattern.compile("^[${.}a-z0-9./_:-]+((:[${.}a-z0-9._-]+)?)$", 8));
        instructionPatterns.put("MAINTAINER", Pattern.compile(".+"));
        instructionPatterns.put("EXPOSE", Pattern.compile("^[${.}A-z0-9]+([.${.}/a-zA-Z0-9\\s]+)?$"));
        instructionPatterns.put("ENV", Pattern.compile("^[${.}a-zA-Z_]+[${.}a-zA-Z0-9_]* .+$"));
        instructionPatterns.put("USER", Pattern.compile("^[${.}a-z_][${.}a-z0-9_]{0,30}$"));
        instructionPatterns.put("RUN", Pattern.compile(".+"));
        instructionPatterns.put("CMD", Pattern.compile(".+"));
        instructionPatterns.put("ONBUILD", Pattern.compile(".+"));
        instructionPatterns.put("ENTRYPOINT", Pattern.compile(".+"));
        instructionPatterns.put("ADD", addPattern);
        instructionPatterns.put("COPY", addPattern);
        instructionPatterns.put("VOLUME", Pattern.compile("^~?([${.}A-z0-9\\/_.-]+|\\[(\\s*)?(\"[A-z0-9\\/_. -]+\"(,\\s*)?)+(\\s*)?\\])$"));
        instructionPatterns.put("WORKDIR", Pattern.compile("^~?[${.}A-z0-9\\/_.-]+$"));
        return instructionPatterns;
    }

    void validate(File src) throws IOException {
        int lineNumber;
        File dockerFile;
        boolean isOnError = false;
        Preconditions.checkArgument((boolean)src.exists(), (String)"Path %s doesn't exist", (Object[])new Object[]{src});
        if (src.isDirectory()) {
            Preconditions.checkState((boolean)new File(src, "Dockerfile").exists(), (Object)("Dockerfile doesn't exist in " + src));
            dockerFile = new File(src, "Dockerfile");
        } else {
            Preconditions.checkState((boolean)"Dockerfile".equals(src.getName()), (Object)("Dockerfile isn't " + src));
            dockerFile = src;
            src = dockerFile.getParentFile();
        }
        List dockerFileContent = FileUtils.readLines((File)dockerFile);
        if (dockerFileContent.size() <= 0) {
            throw new OrchestrationException(String.format("Dockerfile %s is empty", dockerFile));
        }
        File dockerIgnoreFile = new File(src, ".dockerignore");
        if (dockerIgnoreFile.exists()) {
            lineNumber = 0;
            List dockerIgnoreFileContent = FileUtils.readLines((File)dockerIgnoreFile);
            for (String pattern : dockerIgnoreFileContent) {
                ++lineNumber;
                if ((pattern = pattern.trim()).isEmpty()) continue;
                pattern = FilenameUtils.normalize((String)pattern);
                try {
                    if (!GoLangFileMatch.match((String)pattern, (String)"Dockerfile")) continue;
                    logger.error(String.format("Dockerfile is excluded by pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                    isOnError = true;
                }
                catch (GoLangFileMatchException e) {
                    logger.error(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                    isOnError = true;
                }
            }
        }
        lineNumber = 0;
        boolean fromCheck = false;
        String currentLine = "";
        for (String cmd : dockerFileContent) {
            String instructionParams;
            String instruction;
            ++lineNumber;
            if (cmd.trim().isEmpty() || cmd.startsWith("#")) continue;
            currentLine = currentLine + cmd;
            if (cmd.endsWith("\\")) continue;
            if (currentLine.trim().contains(" ")) {
                String[] splitLine = currentLine.trim().split(" ", 2);
                instruction = splitLine[0];
                instructionParams = splitLine[1];
            } else {
                instruction = currentLine.trim();
                instructionParams = null;
            }
            if (!fromCheck) {
                fromCheck = true;
                if (!"FROM".equalsIgnoreCase(instruction)) {
                    logger.error(String.format("Missing or misplaced FROM on line [%d] of %s, found %s", lineNumber, dockerFile, currentLine));
                    isOnError = true;
                }
            } else if ("FROM".equalsIgnoreCase(instruction)) {
                logger.error(String.format("Missing or misplaced FROM on line [%d] of %s, found %s", lineNumber, dockerFile, currentLine));
                isOnError = true;
            }
            if (INSTRUCTIONS_PATTERNS.containsKey(instruction)) {
                if (instructionParams == null) {
                    logger.error(String.format("Missing param on line [%d] of %s, found %s", lineNumber, dockerFile, currentLine));
                    isOnError = true;
                } else {
                    Pattern instructionPattern = INSTRUCTIONS_PATTERNS.get(instruction);
                    Matcher curMatcher = instructionPattern.matcher(instructionParams);
                    if (!curMatcher.matches()) {
                        logger.error(String.format("Wrong %s format on line [%d] of %s, must match", currentLine, lineNumber, dockerFile));
                        isOnError = true;
                    }
                    if ("FROM".equalsIgnoreCase(instruction) && (curMatcher = instructionPattern.matcher(instructionParams)).find()) {
                        String version = "";
                        if (curMatcher.groupCount() >= 1) {
                            version = curMatcher.group(1);
                        }
                        if (version.length() == 0) {
                            logger.warn(String.format("Provide a version and don't use latest version in FROM on line [%d] of %s, found %s", lineNumber, dockerFile, currentLine));
                        } else if (version.equals(":latest")) {
                            logger.warn(String.format("Don't use latest version in FROM on line [%d] of %s, found %s", lineNumber, dockerFile, currentLine));
                        }
                    }
                    if ("RUN".equalsIgnoreCase(instruction) && instructionParams.length() > 100) {
                        String[] realLine = instructionParams.split("\\\\");
                        for (int i = 0; i < realLine.length; ++i) {
                            if (realLine[i].length() <= 100) continue;
                            logger.warn(String.format("The line %d of %s is too long (more than 100 chars) : %s...", lineNumber - realLine.length + i + 1, dockerFile, realLine[i].substring(0, 50)));
                        }
                    }
                }
            } else {
                logger.error(String.format("Wrong instruction %s on line [%d] of %s", currentLine, lineNumber, dockerFile));
                isOnError = true;
            }
            currentLine = "";
        }
        if (!Strings.isNullOrEmpty((String)currentLine)) {
            logger.error(String.format("Last instruction is not finish on line [%d] of %s, please remove the backslash", lineNumber, dockerFile));
            isOnError = true;
        }
        if (isOnError) {
            throw new OrchestrationException(String.format("Error while validate Dockerfile %s.", dockerFile));
        }
    }
}

